/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes;

import com.mojang.authlib.GameProfile;
import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.Objects;
import javax.annotation.Nullable;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import me.duquee.createutilities.voidlink.VoidLinkSlot;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class VoidLinkBehaviour
extends BlockEntityBehaviour
implements ClipboardCloneable {
    public static final BehaviourType<VoidLinkBehaviour> TYPE = new BehaviourType();
    RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    @Nullable
    GameProfile owner;
    VoidLinkSlot firstSlot;
    VoidLinkSlot secondSlot;
    VoidLinkSlot playerSlot;

    public VoidLinkBehaviour(SmartBlockEntity te, Triple<VoidLinkSlot, VoidLinkSlot, VoidLinkSlot> slots) {
        super(te);
        this.firstSlot = (VoidLinkSlot)((Object)slots.getLeft());
        this.secondSlot = (VoidLinkSlot)((Object)slots.getMiddle());
        this.playerSlot = (VoidLinkSlot)((Object)slots.getRight());
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128365_("FrequencyFirst", (Tag)this.frequencyFirst.getStack().m_41739_(new CompoundTag()));
        nbt.m_128365_("FrequencyLast", (Tag)this.frequencyLast.getStack().m_41739_(new CompoundTag()));
        if (this.owner != null) {
            CompoundTag compoundTag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)compoundTag, (GameProfile)this.owner);
            nbt.m_128365_("Owner", (Tag)compoundTag);
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyFirst")));
        this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyLast")));
        this.owner = nbt.m_128425_("Owner", 10) ? NbtUtils.m_129228_((CompoundTag)nbt.m_128469_("Owner")) : null;
    }

    public VoidMotorNetworkHandler.NetworkKey getNetworkKey() {
        return new VoidMotorNetworkHandler.NetworkKey(this.owner, this.frequencyFirst, this.frequencyLast);
    }

    public void setFrequency(boolean first, ItemStack stack) {
        boolean changed;
        stack = stack.m_41777_();
        stack.m_41764_(1);
        ItemStack toCompare = this.getFrequencyStack(first);
        boolean bl = changed = !ItemStack.m_150942_((ItemStack)stack, (ItemStack)toCompare);
        if (changed) {
            this.onLeaveNetwork();
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack);
        }
        if (!changed) {
            return;
        }
        this.blockEntity.sendData();
        this.onJoinNetwork();
        this.updateBlock();
    }

    private void updateBlock() {
        this.blockEntity.m_58904_().m_6289_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_().m_60734_());
    }

    public boolean testHit(int index, Vec3 hit) {
        BlockState state = this.blockEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.blockEntity.m_58899_()));
        return this.getSlot(index).testHit((LevelAccessor)this.blockEntity.m_58904_(), this.blockEntity.m_58899_(), state, localHit);
    }

    public ValueBoxTransform getSlot(int index) {
        return index < 2 ? this.getFrequencySlot(index == 0) : this.playerSlot;
    }

    public ValueBoxTransform getFrequencySlot(boolean first) {
        return first ? this.firstSlot : this.secondSlot;
    }

    public ItemStack getFrequencyStack(boolean first) {
        return first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
    }

    public boolean canInteract(Player player) {
        return !this.isAdventure(player) && this.isOwner(player);
    }

    private boolean isAdventure(Player player) {
        return player != null && !player.m_36326_() && !player.m_5833_();
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile owner) {
        if (!Objects.equals(this.owner, owner)) {
            this.onLeaveNetwork();
            this.owner = owner;
            this.blockEntity.sendData();
            this.onJoinNetwork();
            this.updateBlock();
        }
    }

    protected void onLeaveNetwork() {
    }

    protected void onJoinNetwork() {
    }

    public boolean isOwner(Player player) {
        return this.owner == null || player.m_36316_().equals((Object)this.owner);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public String getClipboardKey() {
        return "Frequencies";
    }

    public boolean writeToClipboard(CompoundTag nbt, Direction side) {
        nbt.m_128365_("First", (Tag)this.frequencyFirst.getStack().m_41739_(new CompoundTag()));
        nbt.m_128365_("Last", (Tag)this.frequencyLast.getStack().m_41739_(new CompoundTag()));
        if (this.owner != null) {
            NBTHelper.putMarker((CompoundTag)nbt, (String)"Owned");
        }
        return true;
    }

    public boolean readFromClipboard(CompoundTag nbt, Player player, Direction side, boolean simulate) {
        if (!(nbt.m_128441_("First") && nbt.m_128441_("Last") && this.isOwner(player))) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.setFrequency(true, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("First")));
        this.setFrequency(false, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Last")));
        this.setOwner(nbt.m_128441_("Owned") ? player.m_36316_() : null);
        return true;
    }
}

