/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.skin;

import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.locallooks.LocalLooks;
import com.github.alexthe666.locallooks.skin.texture.MirrorDownloadingTexture;
import com.google.common.hash.Hashing;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLPaths;

public class SkinLoader {
    private static final String BACKUP_URL = "https://i.imgur.com/38cvzEc.png";

    private static File getSkinCacheFolder() {
        Path configPath = FMLPaths.GAMEDIR.get();
        Path jsonPath = Paths.get(configPath.toAbsolutePath().toString(), "locallooks/cache");
        return jsonPath.toFile();
    }

    public static File getSkinFolder() {
        Path configPath = FMLPaths.GAMEDIR.get();
        Path jsonPath = Paths.get(configPath.toAbsolutePath().toString(), "locallooks/skins");
        if (!Files.exists(jsonPath, new LinkOption[0])) {
            try {
                Files.createDirectories(jsonPath, new FileAttribute[0]);
                LocalLooks.LOGGER.info("Created skin folder for locallooks");
            }
            catch (Exception e) {
                return null;
            }
        }
        return jsonPath.toFile();
    }

    private static ResourceLocation loadSkin(String urlStr, boolean thinArms) {
        String s = Hashing.sha1().hashUnencodedChars((CharSequence)urlStr).toString();
        ResourceLocation resourcelocation = new ResourceLocation("locallooks:skins/" + s + ".png");
        AbstractTexture texture = Minecraft.m_91087_().f_90987_.m_174786_(resourcelocation, null);
        if (texture == null) {
            File file1 = new File(SkinLoader.getSkinCacheFolder(), s.length() > 2 ? s.substring(0, 2) : "xx");
            File file2 = new File(file1, s);
            URL url = null;
            try {
                url = new URL(urlStr);
                URLConnection urlConn = url.openConnection();
                urlConn.addRequestProperty("User-Agent", "Mozilla/4.76");
                urlStr = urlConn.getURL().toString();
            }
            catch (Exception urlConn) {
                // empty catch block
            }
            MirrorDownloadingTexture downloadingtexture = new MirrorDownloadingTexture(file2, urlStr, DefaultPlayerSkin.m_118626_(), !thinArms, () -> {});
            Minecraft.m_91087_().f_90987_.m_118495_(resourcelocation, (AbstractTexture)downloadingtexture);
        }
        return resourcelocation;
    }

    public static ResourceLocation getSkinForPlayer(Player player) {
        String url = BACKUP_URL;
        boolean arms = false;
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)player);
        if (tag.m_128441_("LocalLooksURL")) {
            url = tag.m_128461_("LocalLooksURL");
        }
        if (tag.m_128441_("LocalLooksArms")) {
            arms = tag.m_128471_("LocalLooksArms");
        }
        return SkinLoader.loadSkin(url, arms);
    }

    public static int testURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            URLConnection urlConn = url.openConnection();
            urlConn.addRequestProperty("User-Agent", "Mozilla/4.76");
            String contentType = urlConn.getContentType();
            if (contentType != null && contentType.contains("image")) {
                return 0;
            }
            BufferedImage image = ImageIO.read(url);
            if (image != null) {
                return 0;
            }
            return 1;
        }
        catch (MalformedURLException e) {
            return 2;
        }
        catch (IOException e) {
            return 3;
        }
    }
}

