/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.message;

import com.github.alexthe666.locallooks.LocalLooks;
import com.github.alexthe666.locallooks.config.ConfigHolder;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CloseMirrorMessage {
    private int entityID;
    private boolean offhand;

    public CloseMirrorMessage() {
    }

    public CloseMirrorMessage(int entityID, boolean offhand) {
        this.entityID = entityID;
        this.offhand = offhand;
    }

    public static void write(CloseMirrorMessage message, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(message.entityID);
        packetBuffer.writeBoolean(message.offhand);
    }

    public static CloseMirrorMessage read(FriendlyByteBuf packetBuffer) {
        return new CloseMirrorMessage(packetBuffer.readInt(), packetBuffer.readBoolean());
    }

    public static class Handler {
        public static void handle(CloseMirrorMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity e = ((NetworkEvent.Context)context.get()).getSender().m_9236_().m_6815_(message.entityID);
                if (e instanceof Player) {
                    ItemStack stack;
                    ItemStack itemStack = stack = message.offhand ? ((Player)e).m_21206_() : ((Player)e).m_21205_();
                    if (stack.m_41720_() == LocalLooks.MAGIC_MIRROR.get()) {
                        LocalLooks.PROXY.displayItemInteractionForPlayer((Player)e, stack.m_41777_());
                        if (!((Player)e).m_7500_() && ((Boolean)ConfigHolder.SERVER.singleUseMirror.get()).booleanValue()) {
                            stack.m_41774_(1);
                        }
                    }
                }
            });
        }
    }
}

