/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.client.screen;

import com.github.alexthe666.locallooks.LocalLooks;
import com.github.alexthe666.locallooks.client.screen.LocalSkinSelectionScreen;
import com.github.alexthe666.locallooks.skin.SkinLoader;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class SkinListWidget
extends ObjectSelectionList<Entry> {
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("locallooks:textures/gui/missing_skin.png");
    private final Component name;

    public SkinListWidget(Minecraft mc, int width, int height, Component name) {
        super(mc, width, height, 30, height - 55 + 4, 70);
        this.name = name;
        this.f_93394_ = false;
        this.m_93473_(true, 13);
        this.m_93488_(false);
        this.repopulate();
    }

    public void repopulate() {
        this.m_93516_();
        File parent = SkinLoader.getSkinFolder();
        if (parent != null && !parent.exists()) {
            parent.mkdir();
        }
        String[] extensions = new String[]{"png", "jpg"};
        try {
            if (parent != null) {
                List files = (List)FileUtils.listFiles((File)parent, (String[])extensions, (boolean)true);
                for (File file : files) {
                    this.m_7085_((AbstractSelectionList.Entry)new Entry(file));
                }
            }
        }
        catch (Exception e) {
            LocalLooks.LOGGER.warn("could not open skin folder");
        }
    }

    protected void renderHeader(PoseStack matrixStack, int x, int y, Tesselator tessellator) {
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation prev = Screen.f_279548_;
        Screen.f_279548_ = LocalSkinSelectionScreen.BACKGROUND_LOCATION;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        Screen.f_279548_ = prev;
    }

    public final class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final File file;
        private ResourceLocation resourceLocation;
        @Nullable
        private final AbstractTexture texture;
        private String fileName;
        private boolean selectable = false;

        public Entry(File file) {
            this.file = file;
            this.resourceLocation = new ResourceLocation("locallooks", "localskins/" + file.getName());
            this.texture = this.getTextureForRender();
            this.fileName = file.getName();
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(this.resourceLocation, left, top, 0.0f, 0.0f, 64, 64, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.drawString(Minecraft.m_91087_().f_91062_, this.fileName, (float)(left + 64), (float)(top + 6), this.selectable ? 0xFFFFFF : 0xFF0000, false);
            if (!this.selectable) {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.locallooks.url_warning_4"), left + 64, top + 26, 0xAA0000, true);
            }
            guiGraphics.m_280168_().m_85849_();
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0 && this.selectable) {
                SkinListWidget.this.m_6987_((AbstractSelectionList.Entry)this);
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private AbstractTexture getTextureForRender() {
            boolean flag;
            boolean bl = flag = this.file != null && this.file.isFile();
            if (flag && this.resourceLocation != MISSING_TEXTURE) {
                try (FileInputStream inputstream = new FileInputStream(this.file);){
                    NativeImage nativeimage = NativeImage.m_85058_((InputStream)inputstream);
                    if (nativeimage.m_84982_() == nativeimage.m_85084_()) {
                        DynamicTexture dynamictexture = new DynamicTexture(nativeimage);
                        Minecraft.m_91087_().m_91097_().m_118495_(this.resourceLocation, (AbstractTexture)dynamictexture);
                        this.selectable = true;
                        DynamicTexture dynamicTexture = dynamictexture;
                        return dynamicTexture;
                    }
                }
                catch (Throwable throwable) {
                    LocalLooks.LOGGER.error("Invalid icon for skin {}", (Object)this.file.getName(), (Object)throwable);
                    this.resourceLocation = MISSING_TEXTURE;
                }
            } else {
                Minecraft.m_91087_().m_91097_().m_118513_(this.resourceLocation);
            }
            this.resourceLocation = MISSING_TEXTURE;
            return Minecraft.m_91087_().m_91097_().m_118506_(MISSING_TEXTURE);
        }

        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
        }

        public File getFile() {
            return this.file;
        }

        public Component m_142172_() {
            return SkinListWidget.this.name;
        }
    }
}

