/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.client.screen;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.github.alexthe666.locallooks.LocalLooks;
import com.github.alexthe666.locallooks.client.screen.LocalSkinSelectionScreen;
import com.github.alexthe666.locallooks.config.ConfigHolder;
import com.github.alexthe666.locallooks.message.CloseMirrorMessage;
import com.github.alexthe666.locallooks.skin.SkinLoader;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.net.MalformedURLException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class LookCustomizationScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("locallooks:textures/gui/mirror.png");
    private static final ResourceLocation TEXTURE_SHEEN = new ResourceLocation("locallooks:textures/gui/mirror_sheen.png");
    private static final Component TITLE_TEXT = Component.m_237115_((String)"gui.locallooks.mirror_title");
    private static final Component ENTER_URL_TEXT = Component.m_237115_((String)"gui.locallooks.enter_url");
    private int sizePx = 250;
    private EditBox skinURLField;
    private String enteredURL;
    private float mousePosX;
    private float mousePosY;
    private int loadingWarning;
    private Button refreshURLBtn;
    private Button selectFileBtn;
    private boolean smallArms = false;
    private float transProgress = 0.0f;
    private float prevTransProgress = 0.0f;
    private boolean offhand;
    private boolean consumeMirror;

    public LookCustomizationScreen(boolean offhand) {
        super(TITLE_TEXT);
        this.enteredURL = "";
        this.loadingWarning = 0;
        this.transProgress = 0.0f;
        this.offhand = offhand;
    }

    public LookCustomizationScreen(boolean offhand, File fileIn) {
        super(TITLE_TEXT);
        this.loadingWarning = 0;
        this.transProgress = 0.0f;
        this.offhand = offhand;
        try {
            this.enteredURL = fileIn.toURL().toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.changePlayerTexture(false, false, false, true);
    }

    private boolean isCreative() {
        return Minecraft.m_91087_().f_91074_.m_7500_() || Minecraft.m_91087_().f_91074_.m_5833_();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        this.prevTransProgress = this.transProgress;
        this.skinURLField.m_94120_();
        if (this.transProgress > 0.0f) {
            this.transProgress -= 0.5f;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.sizePx) / 2;
        int j = (this.f_96544_ - this.sizePx) / 2;
        this.refreshURLBtn = Button.m_253074_((Component)Component.m_237115_((String)"gui.locallooks.refresh"), button -> {
            this.enteredURL = this.skinURLField.m_94155_();
            this.loadingWarning = SkinLoader.testURL(this.enteredURL);
            this.changePlayerTexture(false, true, false, false);
        }).m_253046_(100, 20).m_252794_(i + 128, j + 75).m_253136_();
        this.m_142416_((GuiEventListener)this.refreshURLBtn);
        this.refreshURLBtn.f_93623_ = false;
        this.skinURLField = new EditBox(this.f_96547_, i + 130, j + 50, 180, 20, (Component)Component.m_237115_((String)"selectWorld.enterName")){

            protected MutableComponent m_5646_() {
                return super.m_5646_().m_130946_(". ").m_7220_(ENTER_URL_TEXT).m_130946_(" ").m_130946_(LookCustomizationScreen.this.enteredURL);
            }
        };
        this.skinURLField.m_94199_(50000);
        this.skinURLField.m_94144_(this.enteredURL);
        this.skinURLField.m_94151_(p_214319_1_ -> {
            this.enteredURL = p_214319_1_;
            this.refreshURLBtn.f_93623_ = !this.skinURLField.m_94155_().isEmpty();
        });
        this.m_142416_((GuiEventListener)this.skinURLField);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.locallooks.toggle_arms"), button -> {
            this.smallArms = !this.smallArms;
            this.changePlayerTexture(false, false, true, false);
        }).m_253046_(140, 20).m_252794_(i + 150, j + 160).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.locallooks.reset"), button -> this.changePlayerTexture(true, true, false, false)).m_253046_(140, 20).m_252794_(i + 150, j + 190).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
            this.m_7379_();
            Minecraft.m_91087_().m_91152_(null);
        }).m_253046_(140, 20).m_252794_(i + 150, j + 220).m_253136_());
        this.selectFileBtn = Button.m_253074_((Component)Component.m_237115_((String)"gui.locallooks.select_file"), button -> Minecraft.m_91087_().m_91152_((Screen)new LocalSkinSelectionScreen(this.offhand))).m_253046_(100, 20).m_252794_(i + 128, j + 100).m_253136_();
        this.m_142416_((GuiEventListener)this.selectFileBtn);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String s = this.skinURLField.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.skinURLField.m_94144_(s);
    }

    private void changePlayerTexture(boolean reset, boolean close, boolean armsOnly, boolean localFile) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.m_91087_().f_91074_);
        boolean prevArms = false;
        String prevURL = "";
        boolean prevNonVanillaSkin = false;
        boolean vanillaSkin = false;
        if (tag.m_128441_("LocalLooksArms")) {
            prevArms = tag.m_128471_("LocalLooksArms");
        }
        if (tag.m_128441_("LocalLooksURL")) {
            prevURL = tag.m_128461_("LocalLooksURL");
        }
        if (tag.m_128441_("LocalLooksSkin")) {
            prevNonVanillaSkin = tag.m_128471_("LocalLooksSkin");
        }
        if (reset) {
            vanillaSkin = true;
            tag.m_128379_("LocalLooksSkin", false);
            tag.m_128359_("LocalLooksURL", "");
        } else if (armsOnly) {
            tag.m_128379_("LocalLooksArms", this.smallArms);
        } else {
            vanillaSkin = false;
            tag.m_128379_("LocalLooksSkin", true);
            tag.m_128379_("LocalLooksArms", this.smallArms);
            tag.m_128359_("LocalLooksURL", this.enteredURL);
        }
        if (localFile) {
            tag.m_128379_("LocalLooksIsLocalSkin", localFile);
        }
        if (this.smallArms != prevArms || !this.enteredURL.equals(prevURL) || prevNonVanillaSkin == vanillaSkin) {
            this.consumeMirror = true;
        }
        CitadelEntityData.setCitadelTag((LivingEntity)Minecraft.m_91087_().f_91074_, (CompoundTag)tag);
        Citadel.sendMSGToServer((Object)new PropertiesMessage("CitadelPatreonConfig", tag, Minecraft.m_91087_().f_91074_.m_19879_()));
        this.transProgress = 5.0f;
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.consumeMirror) {
            ItemStack stack;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ItemStack itemStack = stack = this.offhand ? player.m_21206_() : player.m_21205_();
            if (stack.m_41720_() == LocalLooks.MAGIC_MIRROR.get()) {
                LocalLooks.PROXY.displayItemInteractionForPlayer((Player)player, stack.m_41777_());
                if (!this.isCreative() && ((Boolean)ConfigHolder.SERVER.singleUseMirror.get()).booleanValue()) {
                    stack.m_41774_(1);
                }
            }
            player.m_5496_((SoundEvent)LocalLooks.MIRROR_SOUND.get(), 1.0f, 1.0f);
            LocalLooks.sendMSGToServer(new CloseMirrorMessage(player.m_19879_(), this.offhand));
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        float f = (float)Math.atan((float)(-x) / 40.0f);
        float f1 = (float)Math.atan((float)(-y) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)(-Math.PI));
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        this.mousePosX = x;
        this.mousePosY = y;
        int k = (this.f_96543_ - this.sizePx - 200) / 2;
        int l = (this.f_96544_ - this.sizePx + 10) / 2;
        guiGraphics.m_280430_(this.f_96547_, TITLE_TEXT, k + 95, l + 4, 0xA0A0A0);
        guiGraphics.m_280430_(this.f_96547_, ENTER_URL_TEXT, k + 230, l + 30, 0xA0A0A0);
        if (this.loadingWarning > 0) {
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)("gui.locallooks.url_warning_" + this.loadingWarning)), k + 320, l + 77, 0xFF0000);
        }
        guiGraphics.m_280163_(TEXTURE, k, l, 0.0f, 0.0f, this.sizePx, this.sizePx, this.sizePx, this.sizePx);
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-f1 * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)(k + 125), (int)(l + 195), (int)70, (Quaternionf)quaternionf, (Quaternionf)quaternionf1, (LivingEntity)entity);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_SHEEN);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.sheenBlit(guiGraphics.m_280168_().m_85850_().m_252922_(), k, l, this.sizePx, this.sizePx, 0.0f, 1.0f, 0.0f, 1.0f, partialTicks);
        guiGraphics.m_280168_().m_85836_();
        this.skinURLField.m_88315_(guiGraphics, x, y, partialTicks);
        guiGraphics.m_280168_().m_85849_();
    }

    private void sheenBlit(Matrix4f matrix, int x1, int y1, int w, int h, float minU, float maxU, float minV, float maxV, float partialTick) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        float offsetB = 1000.0f;
        float startAlpha = 0.3f + Mth.m_14031_((float)(((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTick) * 0.01f)) * 0.1f;
        float progress = 0.2f * Mth.m_14179_((float)partialTick, (float)this.prevTransProgress, (float)this.transProgress);
        float alpha = startAlpha + progress * (1.0f - startAlpha);
        bufferbuilder.m_252986_(matrix, (float)x1, (float)y1 + (float)h, offsetB).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x1 + (float)w, (float)y1 + (float)h, offsetB).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x1 + (float)w, (float)y1, offsetB).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x1, (float)y1, offsetB).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(minU, minV).m_5752_();
        RenderSystem.enableBlend();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }
}

