/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.particle;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.particle.ParticleRotating;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ParticleItem
extends ParticleRotating {
    public static HashSet<String> itemBlacklist = new HashSet();
    public BakedModel bakedModel;
    public ItemStack itemStack;
    private final RenderBuffers renderBuffers;
    private final EntityRenderDispatcher entityRenderDispatcher;
    public float xFrom;
    public float yFrom;
    public float zFrom;
    public float xTo;
    public float yTo;
    public float zTo;

    public ParticleItem(ClientLevel pLevel, float brightness, ItemStack itemStack, RenderBuffers renderBuffers, EntityRenderDispatcher entityRenderDispatcher, float xFrom, float yFrom, float zFrom, float xTo, float yTo, float zTo) {
        super(pLevel, xFrom, yFrom, zFrom);
        this.f_107225_ = Integer.MAX_VALUE;
        this.f_107226_ = 0.0f;
        this.m_107250_(0.2f, 0.2f);
        this.f_107663_ = 1.0f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.xFrom = xFrom;
        this.yFrom = yFrom;
        this.zFrom = zFrom;
        this.xTo = xTo;
        this.yTo = yTo;
        this.zTo = zTo;
        this.m_107253_(this.getColorRed() * brightness, this.getColorGreen() * brightness, this.getColorBlue() * brightness);
        this.bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, (Level)Minecraft.m_91087_().f_91073_, null, 0);
        this.itemStack = itemStack;
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.rotationYaw = pLevel.m_213780_().m_188501_() * 360.0f;
        this.renderBuffers = renderBuffers;
    }

    @Override
    public ParticleRenderType m_7556_() {
        return TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL;
    }

    protected float m_5970_() {
        return this.bakedModel.m_6160_().m_118409_();
    }

    protected float m_5952_() {
        return this.bakedModel.m_6160_().m_118410_();
    }

    protected float m_5951_() {
        return this.bakedModel.m_6160_().m_118411_();
    }

    protected float m_5950_() {
        return this.bakedModel.m_6160_().m_118412_();
    }

    public void m_107250_(float pWidth, float pHeight) {
        super.m_107250_(pWidth, pHeight);
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= 6) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }

    @Override
    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        if (itemBlacklist.contains(this.itemStack.m_41720_().toString())) {
            return;
        }
        Vec3 vec3 = pRenderInfo.m_90583_();
        float f = (float)Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_);
        float f1 = (float)Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_);
        float f2 = (float)Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_);
        float lerp = ((float)this.f_107224_ + pPartialTicks) / 3.0f;
        double d0 = this.xTo;
        double d1 = this.yTo;
        double d2 = this.zTo;
        double x = Mth.m_14139_((double)lerp, (double)f, (double)d0);
        double y = Mth.m_14139_((double)lerp, (double)f1, (double)d1);
        double z = Mth.m_14139_((double)lerp, (double)f2, (double)d2);
        if (this.f_107224_ >= 3) {
            x = this.xTo;
            y = this.yTo;
            z = this.zTo;
        }
        x -= vec3.m_7096_();
        y -= vec3.m_7098_();
        z -= vec3.m_7094_();
        int j = this.m_6355_(pPartialTicks);
        Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(this.rotationYaw));
        PoseStack pose = new PoseStack();
        pose.m_85836_();
        pose.m_85837_(x, y, z);
        pose.m_85841_(this.f_107663_, this.f_107663_, this.f_107663_);
        pose.m_272245_(quaternion, 0.0f, 1.0f, 0.0f);
        try {
            Minecraft.m_91087_().m_91291_().m_115143_(this.itemStack, ItemDisplayContext.GROUND, false, pose, (MultiBufferSource)this.renderBuffers.m_110104_(), j, OverlayTexture.f_118083_, this.bakedModel);
            this.renderBuffers.m_110104_().m_109911_();
        }
        catch (Exception exception) {
            CULog.err((String)("ERROR, exception trying to render item: " + this.itemStack.m_41720_().toString() + " - adding to ParticleItem render blacklist for this minecraft session"));
            itemBlacklist.add(this.itemStack.m_41720_().toString());
            exception.printStackTrace();
        }
    }
}

