/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Pregnancy;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.interaction.gifts.GiftType;
import forge.net.mca.entity.interaction.gifts.Response;
import forge.net.mca.item.SpecialCaseGift;
import forge.net.mca.network.s2c.AnalysisResults;
import forge.net.mca.resources.data.analysis.IntAnalysis;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;

public class BreedableRelationship
extends Relationship<VillagerEntityMCA> {
    private static final CDataParameter<Boolean> IS_PROCREATING = CParameter.create("isProcreating", false);
    private static final CDataParameter<Integer> LAST_PROCREATION = CParameter.create("lastProcreation", 0);
    private int procreateTick = -1;
    private final Pregnancy pregnancy;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return Relationship.createTrackedData(builder).addAll(IS_PROCREATING, LAST_PROCREATION).add(Pregnancy::createTrackedData);
    }

    public BreedableRelationship(VillagerEntityMCA entity) {
        super(entity);
        this.pregnancy = new Pregnancy(entity);
    }

    public Pregnancy getPregnancy() {
        return this.pregnancy;
    }

    public boolean isProcreating() {
        return (Boolean)((VillagerEntityMCA)this.entity).getTrackedValue(IS_PROCREATING);
    }

    public boolean mayProcreateAgain(long time) {
        int intTime = (int)time;
        Integer trackedValue = (Integer)((VillagerEntityMCA)this.entity).getTrackedValue(LAST_PROCREATION);
        int delta = intTime - trackedValue;
        return trackedValue == 0 || delta < 0 || delta > Config.getInstance().procreationCooldown;
    }

    public void startProcreating(long time) {
        this.procreateTick = 60;
        ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, true);
        ((VillagerEntityMCA)this.entity).setTrackedValue(LAST_PROCREATION, (int)time);
    }

    public void tick(int age) {
        if (age % 20 == 0) {
            this.pregnancy.tick();
        }
        if (!this.isProcreating()) {
            return;
        }
        if (this.procreateTick > 0) {
            --this.procreateTick;
            ((VillagerEntityMCA)this.entity).m_21573_().m_26573_();
            ((VillagerEntityMCA)this.entity).m_9236_().m_7605_((Entity)this.entity, (byte)12);
        } else {
            this.getFamilyTree().getOrCreate((Entity)this.entity);
            this.getPartner().ifPresent(spouse -> {
                this.pregnancy.procreate((Entity)spouse);
                ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, false);
            });
        }
    }

    public void giveGift(ServerPlayer player, Memories memory) {
        ItemStack stack = player.m_21205_();
        if (!stack.m_41619_() && !this.handleSpecialCaseGift(player, stack)) {
            Optional<GiftType> gift = GiftType.bestMatching((VillagerEntityMCA)this.entity, stack, player);
            if (gift.isPresent()) {
                this.acceptGift(stack, gift.get(), player, memory);
            } else {
                gift = this.handleDynamicGift(stack);
                if (gift.isPresent()) {
                    this.acceptGift(stack, gift.get(), player, memory);
                } else {
                    this.rejectGift((Player)player, "gift.fail");
                }
            }
        }
    }

    private Optional<GiftType> handleDynamicGift(ItemStack stack) {
        FoodProperties component;
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            float satisfaction = sword.m_43299_();
            satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.m_41720_(), (int)satisfaction, MCA.locate("swords")));
        }
        Item satisfaction = stack.m_41720_();
        if (satisfaction instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem ranged = (ProjectileWeaponItem)satisfaction;
            float satisfaction2 = ranged.m_6615_();
            satisfaction2 = (float)(Math.pow(satisfaction2, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.m_41720_(), (int)satisfaction2, MCA.locate("archery")));
        }
        satisfaction = stack.m_41720_();
        if (satisfaction instanceof TieredItem) {
            TieredItem tool = (TieredItem)satisfaction;
            float satisfaction3 = tool.m_43314_().m_6624_();
            satisfaction3 = (float)(Math.pow(satisfaction3, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.m_41720_(), (int)satisfaction3, MCA.locate(stack.m_41720_() instanceof AxeItem ? "swords" : (stack.m_41720_() instanceof HoeItem ? "hoes" : (stack.m_41720_() instanceof ShovelItem ? "shovels" : "pickaxes")))));
        }
        satisfaction = stack.m_41720_();
        if (satisfaction instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)satisfaction;
            int satisfaction4 = (int)(Math.pow(armor.m_40404_(), 1.25) * 1.5 + (double)(armor.m_40401_().m_6651_() * 5.0f));
            return Optional.of(new GiftType(stack.m_41720_(), satisfaction4, MCA.locate("armor")));
        }
        if (stack.m_41720_().m_41472_() && (component = stack.m_41720_().m_41473_()) != null) {
            int satisfaction5 = (int)((float)component.m_38744_() + component.m_38745_() * 3.0f);
            return Optional.of(new GiftType(stack.m_41720_(), satisfaction5, MCA.locate("food")));
        }
        return Optional.empty();
    }

    private void acceptGift(ItemStack stack, GiftType gift, ServerPlayer player, Memories memory) {
        if (!((VillagerEntityMCA)this.entity).m_35311_().m_19183_(stack)) {
            this.rejectGift((Player)player, "villager.inventory.full");
            return;
        }
        IntAnalysis analysis = gift.getSatisfactionFor((VillagerEntityMCA)this.entity, stack, player);
        int satisfaction = analysis.getTotal();
        Response response = gift.getResponse(satisfaction);
        int occurrences = this.getGiftSaturation().get(stack);
        int penalty = (int)((double)((float)occurrences * Config.getInstance().giftDesaturationFactor) * Math.pow(Math.max((double)satisfaction, 0.0), Config.getInstance().giftDesaturationExponent));
        if (penalty != 0) {
            analysis.add("desaturation", -penalty);
        }
        int desaturatedSatisfaction = analysis.getTotal();
        Response desaturatedResponse = gift.getResponse(desaturatedSatisfaction);
        desaturatedSatisfaction = (int)((double)desaturatedSatisfaction * Config.getInstance().giftSatisfactionFactor);
        NetworkHandler.sendToPlayer(new AnalysisResults(analysis), player);
        if (response == Response.FAIL) {
            this.rejectGift((Player)player, gift.getDialogueFor(response));
        } else if (desaturatedResponse == Response.FAIL) {
            this.rejectGift((Player)player, "gift.saturated");
        } else {
            ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, gift.getDialogueFor(response), new Object[0]);
            if (response == Response.BEST) {
                ((VillagerEntityMCA)this.entity).playSurprisedSound();
            }
            this.getGiftSaturation().add(stack);
            ((VillagerEntityMCA)this.entity).m_9236_().m_7605_((Entity)this.entity, (byte)16);
            ((VillagerEntityMCA)this.entity).m_35311_().m_19173_(stack.m_41620_(1));
        }
        ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue((int)((float)desaturatedSatisfaction * Config.getInstance().giftMoodEffect + Config.getInstance().baseGiftMoodEffect * (float)Mth.m_14205_((double)desaturatedSatisfaction)));
        CriterionMCA.HEARTS_CRITERION.trigger(player, memory.getHearts(), desaturatedSatisfaction, "gift");
        memory.modHearts(desaturatedSatisfaction);
    }

    private void rejectGift(Player player, String dialogue) {
        ((VillagerEntityMCA)this.entity).m_9236_().m_7605_((Entity)this.entity, (byte)15);
        ((VillagerEntityMCA)this.entity).sendChatMessage(player, dialogue, new Object[0]);
    }

    private boolean handleSpecialCaseGift(ServerPlayer player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SpecialCaseGift) {
            if (((SpecialCaseGift)item).handle(player, (VillagerEntityMCA)this.entity)) {
                stack.m_41774_(1);
            }
            return true;
        }
        if (item == Items.f_42502_ && !((VillagerEntityMCA)this.entity).m_6162_()) {
            if (this.pregnancy.tryStartGestation()) {
                player.m_9236_().m_7605_((Entity)this.entity, (byte)12);
                stack.m_41774_(1);
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "gift.cake.success", new Object[0]);
            } else {
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "gift.cake.fail", new Object[0]);
            }
            return true;
        }
        if (item == Items.f_42436_ && ((VillagerEntityMCA)this.entity).isInfected()) {
            ((VillagerEntityMCA)this.entity).setInfected(false);
            ((VillagerEntityMCA)this.entity).m_5584_(((VillagerEntityMCA)this.entity).m_9236_(), stack);
            stack.m_41774_(1);
            return true;
        }
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            ((VillagerEntityMCA)this.entity).setHairDye(dye.m_41089_());
            stack.m_41774_(1);
            return true;
        }
        if (item == Items.f_41903_) {
            ((VillagerEntityMCA)this.entity).clearHairDye();
            stack.m_41774_(1);
            return true;
        }
        if (item == Items.f_42656_) {
            if (stack.m_41788_()) {
                ((VillagerEntityMCA)this.entity).setCustomSkin(stack.m_41786_().getString());
            } else {
                ((VillagerEntityMCA)this.entity).setCustomSkin("");
            }
            stack.m_41774_(1);
            return true;
        }
        if (item == Items.f_42436_ && ((VillagerEntityMCA)this.entity).m_6162_()) {
            ((VillagerEntityMCA)this.entity).m_146758_(24000);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }
}

