/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.menus.base;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.teamresourceful.resourcefullib.common.menu.MenuContent;
import com.teamresourceful.resourcefullib.common.menu.MenuContentSerializer;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.base.members.MemberState;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;

public abstract class MembersContent
implements MenuContent<MembersContent> {
    private final UUID id;
    private final int selected;
    private final List<? extends Member> members;
    private final boolean canManageMembers;
    private final boolean canManagePermissions;

    public MembersContent(UUID id, int selected, List<? extends Member> members, boolean canManageMembers, boolean canManagePermissions) {
        this.id = id;
        this.selected = selected;
        this.members = members;
        this.canManageMembers = canManageMembers;
        this.canManagePermissions = canManagePermissions;
    }

    public UUID id() {
        return this.id;
    }

    public int selected() {
        return this.selected;
    }

    public List<? extends Member> members() {
        return this.members;
    }

    public boolean canManageMembers() {
        return this.canManageMembers;
    }

    public boolean canManagePermissions() {
        return this.canManagePermissions;
    }

    public Member getSelected() {
        if (this.selected() >= 0 && this.selected() < this.members().size()) {
            return this.members().get(this.selected());
        }
        return null;
    }

    public Member getSelf() {
        for (Member member : this.members()) {
            if (!ModUtils.areProfilesSame(member.profile(), Minecraft.m_91087_().m_91094_().m_92548_())) continue;
            return member;
        }
        return null;
    }

    public OptionalInt getId(GameProfile profile) {
        if (profile != null) {
            for (int i = 0; i < this.members().size(); ++i) {
                Member member = this.members().get(i);
                if (!member.profile().equals((Object)profile)) continue;
                return OptionalInt.of(i);
            }
        }
        return OptionalInt.empty();
    }

    public static class Serializer
    implements MenuContentSerializer<MembersContent> {
        private final Factory<?> factory;
        private final CreateMemberFactory createMemberFactory;

        public Serializer(Factory<?> factory, CreateMemberFactory createMember) {
            this.factory = factory;
            this.createMemberFactory = createMember;
        }

        public MembersContent from(FriendlyByteBuf buffer) {
            List members = buffer.m_236845_(buf -> {
                GameProfile profile = buf.m_236875_();
                MemberState state = (MemberState)buf.m_130066_(MemberState.class);
                Set permissions = (Set)buf.m_236838_(Sets::newHashSetWithExpectedSize, FriendlyByteBuf::m_130277_);
                String role = buf.m_130277_();
                Member member = this.createMemberFactory.createMember(profile, state, permissions);
                member.setRole(role);
                return member;
            });
            boolean removeMembers = buffer.readBoolean();
            boolean canChangePermissions = buffer.readBoolean();
            UUID id = buffer.m_130259_();
            int selected = buffer.readInt();
            return this.factory.createMemberContent(id, selected, members, removeMembers, canChangePermissions);
        }

        public void to(FriendlyByteBuf buffer, MembersContent content) {
            buffer.m_236828_(content.members(), (buf, member) -> {
                buf.m_236803_(member.profile());
                buf.m_130068_((Enum)member.getState());
                buf.m_236828_(member.permissions(), FriendlyByteBuf::m_130070_);
                buf.m_130070_(member.getRole());
            });
            buffer.writeBoolean(content.canManageMembers());
            buffer.writeBoolean(content.canManagePermissions());
            buffer.m_130077_(content.id());
            buffer.writeInt(content.selected());
        }

        @FunctionalInterface
        public static interface Factory<T extends MembersContent> {
            public T createMemberContent(UUID var1, int var2, List<? extends Member> var3, boolean var4, boolean var5);
        }

        @FunctionalInterface
        public static interface CreateMemberFactory {
            public Member createMember(GameProfile var1, MemberState var2, Set<String> var3);
        }
    }
}

