/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.base;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.base.members.Members;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class ManageCommands {
    public static <M extends Member, T extends Group<M, ?>> ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> invite(String kind, MemberException youCantManageMembersException, MemberException alreadyInGroupException, CommandHelper.GetGroupAction<M, T> groupAction) {
        return Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            Object group = groupAction.getGroup(player, false);
            CommandHelper.runAction(() -> {
                Object member = group.getMember((Player)player);
                if (player.m_20148_().equals(target.m_20148_())) {
                    throw MemberException.YOU_CANT_INVITE_YOURSELF;
                }
                if (((Members)group.members()).isMember(target.m_20148_())) {
                    throw alreadyInGroupException;
                }
                if (!((Member)member).hasPermission("manage.members")) {
                    throw youCantManageMembersException;
                }
                ((Members)group.members()).invite(target.m_36316_());
                player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.invited", (Object[])new Object[]{target.m_7755_().getString()}), false);
                target.m_5661_(CommonUtils.serverTranslatable((String)("text.argonauts.member." + kind + "_invite"), (Object[])new Object[]{player.m_7755_().getString()}), false);
                target.m_5661_((Component)ConstantComponents.CLICK_HERE_TO_JOIN.m_6881_().m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)CommonUtils.serverTranslatable((String)"text.argonauts.member.join", (Object[])new Object[]{group.displayName()}))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + kind + " join " + player.m_36316_().getName()))), false);
            });
            return 1;
        }));
    }

    public static <M extends Member, T extends Group<M, ?>> ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> remove(MemberException youCantRemoveYourselfFromGroupException, MemberException youCantRemoveGroupLeaderException, MemberException youCantManageMembersInGroupException, CommandHelper.GetGroupAction<M, T> groupAction, RemoveAction action) {
        return Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            Object group = groupAction.getGroup(player, false);
            CommandHelper.runAction(() -> {
                Object member = group.getMember((Player)player);
                if (!((Member)member).hasPermission("manage.members")) {
                    throw youCantManageMembersInGroupException;
                }
                if (player.m_20148_().equals(target.m_20148_())) {
                    throw youCantRemoveYourselfFromGroupException;
                }
                if (((Members)group.members()).isLeader(target.m_20148_())) {
                    throw youCantRemoveGroupLeaderException;
                }
                action.remove(group.id(), target);
            });
            return 1;
        }));
    }

    @FunctionalInterface
    public static interface RemoveAction {
        public void remove(UUID var1, ServerPlayer var2) throws MemberException;
    }
}

