/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.base;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.utils.EventUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;

public final class BaseModCommands {
    public static <M extends Member, T extends Group<M, ?>> ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> tp(CommandHelper.GetGroupAction<M, T> getGroupAction, MemberException notInSameGroupException, MemberException youCantTpMembersInGroupException, AdditionalChecks<M, T> additionalChecks) {
        return Commands.m_82127_((String)"tp").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            CommandHelper.runAction(() -> {
                Object otherGroup;
                Object group = getGroupAction.getGroup(player, false);
                if (group != (otherGroup = getGroupAction.getGroup(target, true))) {
                    throw notInSameGroupException;
                }
                Object member = ((Group)group).getMember((Player)player);
                Object targetMember = ((Group)group).getMember((Player)target);
                if (!((Member)member).hasPermission("tp.members")) {
                    throw youCantTpMembersInGroupException;
                }
                additionalChecks.check(group, (Member)targetMember);
                if (EventUtils.tpCommand(player, target.m_20183_())) {
                    player.m_8999_(target.m_284548_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_146908_(), target.m_146909_());
                }
            });
            return 1;
        }));
    }

    public static <M extends Member, T extends Group<M, ?>> ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> warp(CommandHelper.GetGroupAction<M, T> getGroupAction, MemberException youCantTpMembersException) {
        return Commands.m_82127_((String)"warp").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Object group = getGroupAction.getGroup(player, false);
            CommandHelper.runAction(() -> {
                Object member = group.getMember((Player)player);
                if (!((Member)member).hasPermission("tp.members")) {
                    throw youCantTpMembersException;
                }
                BaseModCommands.tpAllMembers(group, player);
            });
            return 1;
        });
    }

    public static void tpAllMembers(Group<?, ?> group, ServerPlayer target) {
        PlayerList list = target.f_8924_.m_6846_();
        for (Member member : group.members()) {
            ServerPlayer player;
            if (member.profile().getId().equals(target.m_20148_()) || (player = list.m_11259_(member.profile().getId())) == null || !EventUtils.tpCommand(player, target.m_20183_())) continue;
            player.m_8999_(target.m_284548_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_146908_(), target.m_146909_());
        }
    }

    @FunctionalInterface
    public static interface AdditionalChecks<M extends Member, T extends Group<M, ?>> {
        public void check(T var1, Member var2) throws MemberException;
    }
}

