/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.chat.messages;

import com.google.common.primitives.UnsignedInteger;
import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import earth.terrarium.argonauts.client.screens.chat.messages.ChatMessageListEntry;
import earth.terrarium.argonauts.client.screens.chat.messages.ChatPlayerListEntry;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class ChatMessagesList
extends SelectionList<ListEntry> {
    private static final Pattern URL_PATTERN = Pattern.compile("https?://(?:www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b(?:[-a-zA-Z0-9()@:%_+.~#?&/=]*)");

    public ChatMessagesList(int x, int y) {
        super(x, y, 184, 120, 10, entry -> {}, true);
    }

    public void update(LinkedHashMap<UnsignedInteger, ChatMessage> messages) {
        ListEntry last = null;
        for (Map.Entry<UnsignedInteger, ChatMessage> entry : messages.entrySet()) {
            UnsignedInteger id = entry.getKey();
            ChatMessage message = entry.getValue();
            last = this.addMessage(id, message);
        }
        if (last != null) {
            this.ensureVisible(last);
        }
    }

    public ListEntry addMessage(UnsignedInteger id, ChatMessage message) {
        ChatMessageListEntry last = null;
        this.addEntry(new ChatPlayerListEntry(id, message));
        Component text = ChatMessagesList.formatComponent(message.message());
        for (FormattedCharSequence sequence : Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)text, 176)) {
            last = new ChatMessageListEntry(id, sequence);
            this.addEntry(last);
        }
        return last;
    }

    private static Component formatComponent(String text) {
        text = text.replace("\n", " ");
        Matcher matcher = URL_PATTERN.matcher(text);
        MutableComponent component = Component.m_237119_();
        int last = 0;
        while (matcher.find()) {
            String url = matcher.group();
            component.m_7220_((Component)Component.m_237113_((String)text.substring(last, matcher.start())));
            MutableComponent link = Component.m_237113_((String)url).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
            component.m_7220_((Component)link);
            last = matcher.end();
        }
        component.m_7220_((Component)Component.m_237113_((String)text.substring(last)));
        return component;
    }

    public void deleteMessage(UnsignedInteger id) {
        ArrayList<ListEntry> toRemove = new ArrayList<ListEntry>();
        for (ListEntry child : this.m_6702_()) {
            ChatMessageListEntry entry;
            if (child instanceof ChatPlayerListEntry) {
                ChatPlayerListEntry entry2 = (ChatPlayerListEntry)child;
                if (!entry2.id().equals((Object)id)) continue;
                toRemove.add(entry2);
                continue;
            }
            if (!(child instanceof ChatMessageListEntry) || !(entry = (ChatMessageListEntry)child).id().equals((Object)id)) continue;
            toRemove.add(entry);
        }
        for (ListEntry entry : toRemove) {
            this.removeEntry(entry);
        }
    }
}

