/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.base.members;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.scissor.ScissorBoxStack;
import com.teamresourceful.resourcefullib.client.screens.CursorScreen;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.client.utils.ScreenUtils;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MembersList
extends SelectionList<Entry> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("argonauts", "textures/gui/members.png");
    private Entry selected;

    public MembersList(int x, int y, int width, int height, int itemHeight, Consumer<@Nullable Entry> onSelection) {
        super(x, y, width, height, itemHeight, onSelection, true);
    }

    public void update(List<? extends Member> members) {
        this.updateEntries(members.stream().map(x$0 -> new Entry((Member)x$0)).toList());
    }

    public void setSelected(@Nullable Entry entry) {
        super.setSelected((ListEntry)entry);
        this.selected = entry;
    }

    public class Entry
    extends ListEntry {
        private final Member member;
        private final ResourceLocation skin;

        public Entry(Member member) {
            this.member = member;
            this.skin = Entry.getPlayerSkin(member.profile());
        }

        protected void render(@NotNull GuiGraphics graphics, @NotNull ScissorBoxStack scissorStack, int id, int left, int top, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick, boolean selected) {
            graphics.m_280163_(CONTAINER_BACKGROUND, left, top, 276.0f, hovered ? 20.0f : 0.0f, 70, 20, 512, 512);
            PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)this.skin, (int)(left + 2), (int)(top + 2), (int)16);
            try (CloseableScissorStack ignored = RenderUtils.createScissorBoxStack((ScissorBoxStack)scissorStack, (Minecraft)Minecraft.m_91087_(), (PoseStack)graphics.m_280168_(), (int)(left + 20), (int)(top + 2), (int)(width - 24), (int)(height - 4));){
                graphics.m_280056_(Minecraft.m_91087_().f_91062_, this.member.profile().getName(), left + 21, top + 5, 0xFFFFFF, false);
            }
            if (hovered) {
                ScreenUtils.setTooltip((Component)Component.m_237113_((String)this.member.profile().getName()));
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CursorScreen) {
                    CursorScreen cursorScreen = (CursorScreen)screen;
                    cursorScreen.setCursor(CursorScreen.Cursor.POINTER);
                }
            }
        }

        private static ResourceLocation getPlayerSkin(GameProfile profile) {
            if (Minecraft.m_91087_().m_91403_() != null) {
                for (PlayerInfo player : Minecraft.m_91087_().m_91403_().m_105142_()) {
                    if (!ModUtils.areProfilesSame(player.m_105312_(), profile)) continue;
                    return player.m_105337_();
                }
            }
            return profile.getId() == null ? DefaultPlayerSkin.m_118626_() : DefaultPlayerSkin.m_118627_((UUID)profile.getId());
        }

        public void m_93692_(boolean bl) {
        }

        public boolean m_93696_() {
            return this == MembersList.this.selected;
        }

        public GameProfile profile() {
            return this.member.profile();
        }
    }
}

