/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.api.party;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.party.members.IgnoredPartyMembers;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMembers;
import earth.terrarium.argonauts.common.handlers.party.settings.PartySettings;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public final class Party
extends Group<PartyMember, PartyMembers> {
    private final PartySettings settings;
    private final IgnoredPartyMembers ignored;
    public static final ByteCodec<Party> BYTE_CODEC = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.UUID.fieldOf(Group::id), (ObjectEntryByteCodec)PartySettings.BYTE_CODEC.fieldOf(Party::settings), (ObjectEntryByteCodec)PartyMembers.BYTE_CODEC.fieldOf(Group::members), (ObjectEntryByteCodec)ByteCodec.UUID.setOf().map(IgnoredPartyMembers::new, IgnoredPartyMembers::getIgnored).fieldOf(Party::ignored), Party::new);

    public Party(UUID id, PartySettings settings, PartyMembers members, IgnoredPartyMembers ignored) {
        super(id, members);
        this.settings = settings;
        this.ignored = ignored;
    }

    public Party(UUID id, Player leader) {
        this(id, new PartySettings(), new PartyMembers(leader.m_36316_()), new IgnoredPartyMembers());
    }

    @Override
    public boolean isPublic() {
        return this.settings.has("public");
    }

    @Override
    public PartyMember getMember(UUID player) throws MemberException {
        if (!((PartyMembers)this.members()).isMember(player)) {
            throw MemberException.YOU_ARE_NOT_IN_THIS_PARTY;
        }
        return (PartyMember)((PartyMembers)this.members()).get(player);
    }

    public PartySettings settings() {
        return this.settings;
    }

    public IgnoredPartyMembers ignored() {
        return this.ignored;
    }

    public boolean friendlyFireEnabled() {
        return this.settings.has("friendly_fire");
    }

    @Override
    public Component displayName() {
        return CommonUtils.serverTranslatable((String)"text.argonauts.party_name", (Object[])new Object[]{((PartyMember)((PartyMembers)this.members()).getLeader()).profile().getName()});
    }

    @Override
    public ChatFormatting color() {
        return ChatFormatting.WHITE;
    }
}

