/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.api.guild;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.handlers.guild.settings.GuildSettings;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public final class Guild
extends Group<GuildMember, GuildMembers> {
    private final GuildSettings settings;
    public static final ByteCodec<Guild> BYTE_CODEC = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.UUID.fieldOf(Group::id), (ObjectEntryByteCodec)GuildSettings.BYTE_CODEC.fieldOf(Guild::settings), (ObjectEntryByteCodec)GuildMembers.BYTE_CODEC.fieldOf(Group::members), Guild::new);

    public Guild(UUID id, GuildSettings settings, GuildMembers members) {
        super(id, members);
        this.settings = settings;
    }

    public Guild(UUID id, Player owner) {
        this(id, new GuildSettings(), new GuildMembers(owner.m_36316_()));
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public GuildMember getMember(UUID player) throws MemberException {
        if (!((GuildMembers)this.members()).isMember(player)) {
            throw MemberException.YOU_ARE_NOT_IN_THIS_GUILD;
        }
        return (GuildMember)((GuildMembers)this.members()).get(player);
    }

    public GuildSettings settings() {
        return this.settings;
    }

    public Component motd() {
        return this.settings.motd();
    }

    @Override
    public Component displayName() {
        return this.settings.displayName();
    }

    @Override
    public ChatFormatting color() {
        return this.settings.color();
    }
}

