/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfoUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.compat.cadmus.CadmusIntegration;
import earth.terrarium.argonauts.common.compat.heracles.HeraclesIntegration;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMembers;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundSyncGuildsPacket;
import earth.terrarium.argonauts.common.network.messages.ClientboundSyncPartiesPacket;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class Argonauts {
    public static final String MOD_ID = "argonauts";

    public static void init() {
        NetworkHandler.init();
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.init();
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.init();
        }
    }

    public static void onPlayerJoin(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundSyncGuildsPacket(new HashSet<Guild>(GuildApi.API.getAll(player.m_20194_())), Set.of()), player);
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundSyncPartiesPacket(new HashSet<Party>(PartyApi.API.getAll()), Set.of()), player);
        Guild guild = GuildApi.API.get((ServerPlayer)player);
        if (guild == null) {
            return;
        }
        Component motd = guild.settings().motd();
        if (motd.getString().isEmpty()) {
            return;
        }
        player.m_5661_(ConstantComponents.MOTD_HEADER, false);
        player.m_5661_(ModUtils.getParsedComponent(motd, (ServerPlayer)player), false);
        player.m_5661_(ConstantComponents.LINE, false);
    }

    public static void onPlayerLeave(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Party party = PartyApi.API.getPlayerParty(player.m_20148_());
        if (party == null) {
            return;
        }
        if (!((PartyMembers)party.members()).isLeader(player.m_20148_())) {
            return;
        }
        PartyApi.API.disband(party, Objects.requireNonNull(player.m_20194_()));
    }

    public static boolean isCadmusLoaded() {
        return ModInfoUtils.isModLoaded((String)"cadmus");
    }

    public static boolean isHeraclesLoaded() {
        return ModInfoUtils.isModLoaded((String)"heracles");
    }
}

