/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.compat;

import com.mojang.logging.LogUtils;
import dev.emi.trinkets.api.LivingEntityTrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.compat.WrappedTrinketInventory;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class WrappingTrinketsUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Set<String> defaultSlots = Set.of("anklet", "back", "belt", "cape", "charm", "face", "hand", "hat", "necklace", "ring", "shoes", "wrist");

    public static Optional<dev.emi.trinkets.api.SlotReference> createTrinketsReference(SlotReference slotReference) {
        try {
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)slotReference.entity());
            if (capability == null) {
                return Optional.empty();
            }
            AccessoriesContainer container = (AccessoriesContainer)capability.getContainers().get(slotReference.slotName());
            SlotType slotType = SlotTypeLoader.getSlotType((class_1937)slotReference.entity().method_37908(), (String)container.getSlotName());
            WrappedTrinketInventory trinketInv = new WrappedTrinketInventory(new LivingEntityTrinketComponent(slotReference.entity()), container, slotType);
            return Optional.of(new dev.emi.trinkets.api.SlotReference(trinketInv, slotReference.slot()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<SlotReference> createAccessoriesReference(dev.emi.trinkets.api.SlotReference slotReference) {
        TrinketInventory trinketInventory = slotReference.inventory();
        if (!(trinketInventory instanceof WrappedTrinketInventory)) {
            return Optional.empty();
        }
        WrappedTrinketInventory wrappedTrinketInventory = (WrappedTrinketInventory)trinketInventory;
        return Optional.of(SlotReference.of((class_1309)wrappedTrinketInventory.container.capability().entity(), (String)wrappedTrinketInventory.container.getSlotName(), (int)slotReference.index()));
    }

    public static Map<String, Map<String, SlotType>> getGroupedSlots(boolean isClient, class_1299<?> type) {
        HashMap<String, Map<String, SlotType>> groups = new HashMap<String, Map<String, SlotType>>();
        Map entitySlots = EntitySlotLoader.INSTANCE.getSlotTypes(isClient, type);
        if (entitySlots == null) {
            return Map.of();
        }
        for (SlotGroup group : SlotGroupLoader.INSTANCE.getGroups(isClient, false)) {
            for (String slot : group.slots()) {
                if (!entitySlots.containsKey(slot)) continue;
                groups.computeIfAbsent(group.name(), string -> new HashMap()).put(slot, (SlotType)entitySlots.get(slot));
            }
        }
        return groups;
    }

    public static SlotGroup getGroup(class_1937 level, String accessoriesSlot) {
        List groups = SlotGroupLoader.getGroups((class_1937)level, (boolean)false);
        SlotGroup foundGroup = (SlotGroup)SlotGroupLoader.getGroup((class_1937)level, (String)"unsorted").get();
        for (SlotGroup group : groups) {
            if (!group.slots().contains(accessoriesSlot)) continue;
            foundGroup = group;
            break;
        }
        return foundGroup;
    }

    public static String trinketsToAccessories_Slot(Optional<String> group, String trinketType) {
        Object accessoriesType;
        switch (trinketType) {
            case "glove": {
                Object object = "hand";
                break;
            }
            case "aglet": {
                Object object = "anklet";
                break;
            }
            default: {
                Object object = accessoriesType = trinketType;
            }
        }
        if (defaultSlots.contains(accessoriesType)) {
            return accessoriesType;
        }
        if (group.isPresent()) {
            accessoriesType = "trinket_group_" + group.get() + "-" + (String)accessoriesType;
        }
        return accessoriesType;
    }

    public static String accessoriesToTrinkets_Slot(String accessoryType) {
        String trinketType = switch (accessoryType) {
            case "hand" -> "glove";
            case "anklet" -> "aglet";
            default -> accessoryType;
        };
        return WrappingTrinketsUtils.filterGroupInfo(trinketType);
    }

    public static String trinketsToAccessories_Group(String trinketType) {
        return switch (trinketType) {
            case "legs" -> "leg";
            case "offhand", "hand" -> "arm";
            case "charm" -> "misc";
            default -> trinketType;
        };
    }

    public static String accessoriesToTrinkets_Group(String accessoryType) {
        return switch (accessoryType) {
            case "leg" -> "legs";
            case "arm" -> "hand";
            case "misc" -> "charm";
            default -> accessoryType;
        };
    }

    public static class_2960 trinketsToAccessories_Validators(class_2960 location) {
        return switch (location.toString()) {
            case "trinkets:all" -> Accessories.of((String)"all");
            case "trinkets:none" -> Accessories.of((String)"none");
            case "trinkets:tag" -> Accessories.of((String)"tag");
            case "trinkets:relevant" -> Accessories.of((String)"relevant");
            default -> location;
        };
    }

    public static String filterGroupInfo(String trinketType) {
        return trinketType.replaceAll("(trinket_group_).*-", "");
    }

    public static Pair<Optional<String>, String> splitGroupInfo(String path) {
        if (!path.contains("/")) {
            return Pair.of(Optional.empty(), (Object)path);
        }
        String[] parts = path.split("/");
        if (parts.length <= 1) {
            return Pair.of(Optional.empty(), (Object)path);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i]);
        }
        return Pair.of(Optional.of(parts[0]), (Object)builder.toString());
    }
}

