/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Function3;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.api.LivingEntityTrinketComponent;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.compat.EmptyComponent;
import dev.emi.trinkets.compat.WrappedAccessory;
import dev.emi.trinkets.compat.WrappedSlotType;
import dev.emi.trinkets.compat.WrappedTrinket;
import dev.emi.trinkets.compat.WrappedTrinketInventory;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.slf4j.Logger;

public class TrinketsApi
implements EntityComponentInitializer {
    public static final ComponentKey<TrinketComponent> TRINKET_COMPONENT = ComponentRegistryV3.INSTANCE.getOrCreate(new class_2960("trinkets", "trinkets"), TrinketComponent.class);
    private static final Map<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>> PREDICATES = new HashMap<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>>();
    private static final Map<class_1792, Trinket> TRINKETS = new HashMap<class_1792, Trinket>();
    private static final Trinket DEFAULT_TRINKET;

    public static void registerTrinket(class_1792 item, Trinket trinket) {
        AccessoriesAPI.registerAccessory((class_1792)item, (Accessory)new WrappedTrinket(trinket));
        TRINKETS.put(item, trinket);
    }

    public static Trinket getTrinket(class_1792 item) {
        Accessory accessory;
        Trinket trinket = TRINKETS.get(item);
        if (trinket == null && (accessory = AccessoriesAPI.getAccessory((class_1792)item)) != null) {
            trinket = new WrappedAccessory(accessory);
        }
        if (trinket == null) {
            return DEFAULT_TRINKET;
        }
        return trinket;
    }

    public static Trinket getDefaultTrinket() {
        return DEFAULT_TRINKET;
    }

    public static Optional<TrinketComponent> getTrinketComponent(class_1309 livingEntity) {
        if (livingEntity == null) {
            return Optional.empty();
        }
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)livingEntity);
        return Optional.of(capability != null ? new LivingEntityTrinketComponent(livingEntity) : new EmptyComponent(livingEntity));
    }

    public static void onTrinketBroken(class_1799 stack, SlotReference ref, class_1309 entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        io.wispforest.accessories.api.slot.SlotReference reference = io.wispforest.accessories.api.slot.SlotReference.of((class_1309)entity, (String)slotName, (int)ref.index());
        AccessoriesAPI.breakStack((io.wispforest.accessories.api.slot.SlotReference)reference);
    }

    @Deprecated
    public static Map<String, SlotGroup> getPlayerSlots() {
        return TrinketsApi.getEntitySlots(class_1299.field_6097);
    }

    public static Map<String, SlotGroup> getPlayerSlots(class_1937 world) {
        return TrinketsApi.getEntitySlots(world, class_1299.field_6097);
    }

    public static Map<String, SlotGroup> getPlayerSlots(class_1657 player) {
        return TrinketsApi.getEntitySlots((class_1297)player);
    }

    @Deprecated
    public static Map<String, SlotGroup> getEntitySlots(class_1299<?> type) {
        return EntitySlotLoader.SERVER.getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(class_1937 world, class_1299<?> type) {
        return (world.field_9236 ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER).getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(class_1297 entity) {
        if (entity != null) {
            return TrinketsApi.getEntitySlots(entity.method_37908(), entity.method_5864());
        }
        return ImmutableMap.of();
    }

    public static void registerTrinketPredicate(class_2960 id, Function3<class_1799, SlotReference, class_1309, TriState> predicate) {
        PREDICATES.put(id, predicate);
        AccessoriesAPI.registerPredicate((class_2960)id, (SlotBasedPredicate)new SafeSlotBasedPredicate(id, predicate));
    }

    public static Optional<Function3<class_1799, SlotReference, class_1309, TriState>> getTrinketPredicate(class_2960 id) {
        return Optional.ofNullable(PREDICATES.get(id));
    }

    public static boolean evaluatePredicateSet(Set<class_2960> set, class_1799 stack, SlotReference ref, class_1309 entity) {
        HashSet<class_2960> convertedSet = new HashSet<class_2960>();
        for (class_2960 location : set) {
            class_2960 converetdLocation = switch (location.toString()) {
                case "trinkets:all" -> Accessories.of((String)"all");
                case "trinkets:none" -> Accessories.of((String)"none");
                case "trinkets:tag" -> Accessories.of((String)"tag");
                case "trinkets:relevant" -> Accessories.of((String)"relevant");
                default -> location;
            };
            convertedSet.add(converetdLocation);
        }
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        io.wispforest.accessories.api.slot.SlotType slotType = SlotTypeLoader.getSlotType((class_1937)entity.method_37908(), (String)slotName);
        if (slotType == null) {
            throw new IllegalStateException("Unable to get a SlotType using the WrappedTrinketInventory from the SlotTypeLoader! [Name: " + slotName + "]");
        }
        return AccessoriesAPI.getPredicateResults(convertedSet, (class_1937)entity.method_37908(), (io.wispforest.accessories.api.slot.SlotType)slotType, (int)ref.index(), (class_1799)stack);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(class_1309.class, TRINKET_COMPONENT, livingEntity -> TrinketsApi.getTrinketComponent(livingEntity).get());
        registry.registerForPlayers(TRINKET_COMPONENT, player -> TrinketsApi.getTrinketComponent((class_1309)player).get(), RespawnCopyStrategy.ALWAYS_COPY);
    }

    static {
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "all"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.TRUE));
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "none"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.FALSE));
        class_6862 trinketsAll = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("trinkets", "all"));
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "tag"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            SlotType slot = ref.inventory().getSlotType();
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("trinkets", slot.getId()));
            if (stack.method_31573(tag) || stack.method_31573(trinketsAll)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        TrinketsApi.registerTrinketPredicate(new class_2960("trinkets", "relevant"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            io.wispforest.accessories.api.slot.SlotReference reference = io.wispforest.accessories.api.slot.SlotReference.of((class_1309)entity, (String)ref.inventory().getSlotType().getName(), (int)ref.index());
            AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(reference);
            AccessoriesAPI.getAccessory((class_1799)stack).getDynamicModifiers(stack, reference, builder);
            if (!builder.getAttributeModifiers(false).isEmpty()) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        DEFAULT_TRINKET = new WrappedAccessory(AccessoriesAPI.defaultAccessory());
    }

    private static final class SafeSlotBasedPredicate
    implements SlotBasedPredicate {
        private static final Logger LOGGER = LogUtils.getLogger();
        private boolean hasErrored = false;
        private final class_2960 location;
        private final Function3<class_1799, SlotReference, class_1309, TriState> trinketPredicate;

        public SafeSlotBasedPredicate(class_2960 location, Function3<class_1799, SlotReference, class_1309, TriState> trinketPredicate) {
            this.location = location;
            this.trinketPredicate = trinketPredicate;
        }

        public TriState isValid(class_1937 level, io.wispforest.accessories.api.slot.SlotType slotType, int slot, class_1799 stack) {
            if (this.hasErrored) {
                return TriState.DEFAULT;
            }
            try {
                return (TriState)this.trinketPredicate.apply((Object)stack, (Object)new SlotReference(new CursedTrinketInventory(slotType, level.method_8608()), slot), null);
            }
            catch (Exception e) {
                this.hasErrored = true;
                LOGGER.warn("Unable to handle Trinket Slot Predicate converted to Accessories Slot Predicate due to fundamental incompatibility, issues may be present with it! [Slot: {}, Predicate ID: {}]", new Object[]{slotType.name(), this.location, e});
                return TriState.DEFAULT;
            }
        }
    }

    private static final class CursedTrinketInventory
    extends TrinketInventory {
        public CursedTrinketInventory(io.wispforest.accessories.api.slot.SlotType slotType, boolean isClientSide) {
            super(WrappedSlotType.of(slotType, isClientSide), null, inv -> {});
        }
    }
}

