/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.compat.WrappingTrinketsUtils;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;

public class SlotAttributes {
    private static Map<String, UUID> CACHED_UUIDS = Maps.newHashMap();
    private static Map<String, SlotEntityAttribute> CACHED_ATTRIBUTES = Maps.newHashMap();

    public static void addSlotModifier(Multimap<class_1320, class_1322> map, String slot, UUID uuid, double amount, class_1322.class_1323 operation) {
        Pair<Optional<String>, String> data = WrappingTrinketsUtils.splitGroupInfo(slot);
        String slotType = WrappingTrinketsUtils.trinketsToAccessories_Slot((Optional)data.left(), (String)data.right());
        SlotAttribute.addSlotModifier(map, (String)slotType, (String)slotType, (UUID)uuid, (double)amount, (class_1322.class_1323)operation);
    }

    public static UUID getUuid(SlotReference ref) {
        String key = ref.inventory().getSlotType().getGroup() + "/" + ref.inventory().getSlotType().getName() + "/" + ref.index();
        CACHED_UUIDS.putIfAbsent(key, UUID.nameUUIDFromBytes(key.getBytes()));
        return CACHED_UUIDS.get(key);
    }

    public static class WrappedSlotAttribute
    extends SlotEntityAttribute {
        private final SlotAttribute attribute;

        public WrappedSlotAttribute(SlotAttribute attribute) {
            super(attribute.slotName());
            this.attribute = attribute;
        }

        public double method_6169() {
            return this.attribute.method_6169();
        }

        public boolean method_6168() {
            return this.attribute.method_6168();
        }

        public class_1320 method_26829(boolean watch) {
            return this.attribute.method_26829(watch);
        }

        public double method_6165(double value) {
            return this.attribute.method_6165(value);
        }

        public String method_26830() {
            return this.attribute.method_26830();
        }
    }

    public static class SlotEntityAttribute
    extends class_1320 {
        public String slot;

        private SlotEntityAttribute(String slot) {
            super("trinkets.slot." + slot, 0.0);
            this.slot = slot;
        }
    }
}

