/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.sparsestructuresreforged;

import com.google.gson.Gson;
import com.teampotato.sparsestructuresreforged.SparseStructuresConfig;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.common.Mod;

@Mod(value="sparsestructuresreforged")
public class SparseStructures {
    public static final String MOD_ID = "sparsestructuresreforged";
    private static final String CONFIG_RESOURCE_NAME = "sparse-structures-default-config.json5";
    private static final String CONFIG_FILENAME = "sparsestructures.json5";
    private static final Path CONFIG_FILE_PATH = Paths.get("config", "sparsestructures.json5");
    public static SparseStructuresConfig config;

    public SparseStructures() {
        InputStream in;
        if (!CONFIG_FILE_PATH.toFile().exists()) {
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(CONFIG_RESOURCE_NAME);
                try {
                    if (in == null) {
                        throw new IllegalStateException("Failed to load SparseStructure's default config \"sparse-structures-default-config.json5\"");
                    }
                    Files.createDirectories(CONFIG_FILE_PATH, new FileAttribute[0]);
                    Files.copy(in, CONFIG_FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            in = Files.newInputStream(CONFIG_FILE_PATH, new OpenOption[0]);
            try {
                config = (SparseStructuresConfig)new Gson().fromJson((Reader)new InputStreamReader(in), SparseStructuresConfig.class);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("SparseStructure's config file is malformed! If you don't know what's causing this, delete the config file and restart the game.");
        }
    }
}

