/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_core.mana_util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_core.mana_util.ManaItem;
import me.fzzyhmstrs.fzzy_core.nbt_util.Nbt;
import me.fzzyhmstrs.fzzy_core.registry.EventRegistry;
import me.fzzyhmstrs.fzzy_core.trinket_util.TrinketChecker;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\u0011\u001a\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0015R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lme/fzzyhmstrs/fzzy_core/mana_util/ManaHelper;", "", "Lnet/minecraft/class_1657;", "user", "", "Lnet/minecraft/class_1799;", "getManaItems", "(Lnet/minecraft/class_1657;)Ljava/util/List;", "stack", "", "initializeManaItem", "(Lnet/minecraft/class_1799;)V", "list", "Lnet/minecraft/class_1937;", "world", "", "healLeft", "manaHealItems", "(Ljava/util/List;Lnet/minecraft/class_1937;I)I", "", "needsInitialization", "(Lnet/minecraft/class_1799;)Z", "tickHeal", "", "", "Lme/fzzyhmstrs/fzzy_core/registry/EventRegistry$Ticker;", "healTickers", "Ljava/util/Map;", "<init>", "()V", "fzzy_core"})
public final class ManaHelper {
    @NotNull
    public static final ManaHelper INSTANCE = new ManaHelper();
    @NotNull
    private static final Map<Long, EventRegistry.Ticker> healTickers = new LinkedHashMap();

    private ManaHelper() {
    }

    public final void initializeManaItem(@NotNull class_1799 stack) {
        class_1792 item;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        long id = Nbt.INSTANCE.makeItemStackId(stack);
        if (!healTickers.containsKey(id) && (item = stack.method_7909()) instanceof ManaItem) {
            Map<Long, EventRegistry.Ticker> map = healTickers;
            Long l = id;
            EventRegistry.Ticker ticker = new EventRegistry.Ticker(((ManaItem)item).getRepairTime());
            map.put(l, ticker);
        }
    }

    public final boolean tickHeal(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        long id = Nbt.INSTANCE.makeItemStackId(stack);
        EventRegistry.Ticker ticker = healTickers.get(id);
        if (ticker == null) {
            return false;
        }
        EventRegistry.Ticker ticker2 = ticker;
        ticker2.tickUp();
        return ticker2.isReady();
    }

    public final boolean needsInitialization(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        long id = Nbt.INSTANCE.getItemStackId(stack);
        return !healTickers.containsKey(id);
    }

    @NotNull
    public final List<class_1799> getManaItems(@NotNull class_1657 user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        List stacks = new ArrayList();
        for (class_1799 stack2 : user.method_31548().field_7547) {
            if (!(stack2.method_7909() instanceof ManaItem) || !stack2.method_7986()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)stack2, (String)"stack2");
            stacks.add(stack2);
        }
        for (class_1799 stack2 : user.method_31548().field_7544) {
            if (!(stack2.method_7909() instanceof ManaItem) || !stack2.method_7986()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)stack2, (String)"stack2");
            stacks.add(stack2);
        }
        for (class_1799 stack2 : user.method_31548().field_7548) {
            if (!(stack2.method_7909() instanceof ManaItem) || !stack2.method_7986()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)stack2, (String)"stack2");
            stacks.add(stack2);
        }
        List<class_1799> stacks2 = TrinketChecker.INSTANCE.getTrinketStacks((class_1309)user);
        Iterable $this$forEach$iv = stacks2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1799 it = (class_1799)element$iv;
            boolean bl = false;
            if (!(it.method_7909() instanceof ManaItem) || !it.method_7986()) continue;
            stacks.add(it);
        }
        return stacks;
    }

    public final int manaHealItems(@NotNull List<class_1799> list, @NotNull class_1937 world, int healLeft) {
        int n;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        int hl = healLeft;
        if (hl <= 0 || list.isEmpty()) {
            return Math.max(0, hl);
        }
        int rnd = world.field_9229.method_43048(list.size());
        class_1799 stack = list.get(rnd);
        int healAmount = Math.min(5, hl);
        class_1792 class_17922 = stack.method_7909();
        ManaItem manaItem = class_17922 instanceof ManaItem ? (ManaItem)class_17922 : null;
        int healedAmount = manaItem == null ? 0 : (n = manaItem.healDamage(healAmount, stack));
        hl -= Math.min(healAmount, healedAmount);
        if (!stack.method_7986()) {
            list.remove(stack);
        }
        return this.manaHealItems(list, world, hl);
    }
}

