/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_core.item_util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_core.FC;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0004\u0011\u0010\u0012\u0013B\u0017\b\u0002\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient;", "", "Lnet/minecraft/class_1799;", "stack", "", "test", "(Lnet/minecraft/class_1799;)Z", "", "toString", "()Ljava/lang/String;", "", "Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Checker;", "checks", "Ljava/util/List;", "<init>", "(Ljava/util/List;)V", "Companion", "Checker", "ItemChecker", "TagChecker", "fzzy_core"})
public final class FzzyIngredient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Checker> checks;

    private FzzyIngredient(List<? extends Checker> checks) {
        this.checks = checks;
    }

    public final boolean test(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        for (Checker check : this.checks) {
            if (!check.check(stack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        Object result = "FzzyIngredient[";
        for (Checker check : this.checks) {
            result = (String)result + "{" + check + "}";
        }
        result = (String)result + "]";
        return result;
    }

    public /* synthetic */ FzzyIngredient(List checks, DefaultConstructorMarker $constructor_marker) {
        this(checks);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Companion;", "", "Lcom/google/gson/JsonObject;", "jsonObject", "Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Checker;", "checkerFromObject", "(Lcom/google/gson/JsonObject;)Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Checker;", "Lcom/google/gson/JsonPrimitive;", "json", "checkerFromPrimitive", "(Lcom/google/gson/JsonPrimitive;)Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Checker;", "Lcom/google/gson/JsonElement;", "Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient;", "fromJson", "(Lcom/google/gson/JsonElement;)Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient;", "Lnet/minecraft/class_1799;", "outputFromJson", "(Lcom/google/gson/JsonObject;)Lnet/minecraft/class_1799;", "<init>", "()V", "fzzy_core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_1799 outputFromJson(@NotNull JsonObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            class_1792 item = class_1869.method_8155((JsonObject)json);
            int i = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
            if (i < 1) {
                throw new JsonSyntaxException("Invalid output count: " + i);
            }
            if (json.has("nbt")) {
                try {
                    class_1799 class_17992;
                    String nbtString = json.getAsJsonPrimitive("nbt").getAsString();
                    class_2487 nbt = class_2522.method_10718((String)nbtString);
                    class_1799 it = class_17992 = new class_1799((class_1935)item, i);
                    boolean bl = false;
                    it.method_7980(nbt);
                    return class_17992;
                }
                catch (Exception e) {
                    FC.INSTANCE.getLOGGER().error("Invalid 'data' string in recipe json");
                    e.printStackTrace();
                }
            }
            return new class_1799((class_1935)item, i);
        }

        @NotNull
        public final FzzyIngredient fromJson(@NotNull JsonElement json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject");
                return new FzzyIngredient(CollectionsKt.listOf((Object)this.checkerFromObject(jsonObject)), null);
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                List checks = new ArrayList();
                for (JsonElement jsonEl : jsonArray) {
                    if (jsonEl.isJsonObject()) {
                        JsonObject jsonObject = jsonEl.getAsJsonObject();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject");
                        checks.add(this.checkerFromObject(jsonObject));
                        continue;
                    }
                    if (jsonEl.isJsonPrimitive()) {
                        JsonPrimitive jsonPrimitive = jsonEl.getAsJsonPrimitive();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonPrimitive, (String)"jsonPrimitive");
                        checks.add(this.checkerFromPrimitive(jsonPrimitive));
                        continue;
                    }
                    throw new IllegalStateException("Improperly formatted FzzyIngredient. JsonArray has illegal member type, needs to be a string or a JsonObject: " + jsonArray);
                }
                return new FzzyIngredient(checks, null);
            }
            if (json.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
                Intrinsics.checkNotNullExpressionValue((Object)jsonPrimitive, (String)"jsonPrimitive");
                return new FzzyIngredient(CollectionsKt.listOf((Object)this.checkerFromPrimitive(jsonPrimitive)), null);
            }
            throw new IllegalStateException("Improperly formatted FzzyIngredient. Needs to be a JsonObject, JsonArray, or Identifier string: " + json);
        }

        private final Checker checkerFromObject(JsonObject jsonObject) {
            if (jsonObject.has("item")) {
                String itemString = jsonObject.getAsJsonPrimitive("item").getAsString();
                class_2960 class_29602 = class_2960.method_12829((String)itemString);
                if (class_29602 == null) {
                    throw new IllegalStateException("Invalid Identifier string in the 'item' member of a SetIngredient object.");
                }
                class_2960 itemId = class_29602;
                if (jsonObject.has("nbt")) {
                    String nbtString = jsonObject.getAsJsonPrimitive("nbt").getAsString();
                    class_2487 nbt = class_2522.method_10718((String)nbtString);
                    Intrinsics.checkNotNullExpressionValue((Object)nbt, (String)"nbt");
                    return new ItemChecker(itemId, nbt);
                }
                return new ItemChecker(itemId, new class_2487());
            }
            if (jsonObject.has("tag")) {
                String tagString = jsonObject.getAsJsonPrimitive("tag").getAsString();
                class_2960 class_29603 = class_2960.method_12829((String)tagString);
                if (class_29603 == null) {
                    throw new IllegalStateException("Invalid Identifier string in the 'tag' member of a SetIngredient object.");
                }
                class_2960 tagId = class_29603;
                if (jsonObject.has("nbt")) {
                    String nbtString = jsonObject.getAsJsonPrimitive("nbt").getAsString();
                    class_2487 nbt = class_2522.method_10718((String)nbtString);
                    Intrinsics.checkNotNullExpressionValue((Object)nbt, (String)"nbt");
                    return new TagChecker(tagId, nbt);
                }
                return new TagChecker(tagId, new class_2487());
            }
            throw new IllegalStateException("Expecting 'item' or 'tag' member in the SetIngredient object");
        }

        private final Checker checkerFromPrimitive(JsonPrimitive json) {
            Checker checker;
            String jsonString = json.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)jsonString, (String)"jsonString");
            if (((CharSequence)jsonString).length() == 0) {
                throw new IllegalStateException("Error in FzzyIngredient: Empty item or tag string");
            }
            if (jsonString.charAt(0) == '#') {
                String string = jsonString.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String tagString = string;
                class_2960 class_29602 = class_2960.method_12829((String)tagString);
                if (class_29602 == null) {
                    throw new IllegalStateException("Error in FzzyIngredient: Unparseable tag identifier: " + tagString);
                }
                class_2960 tagId = class_29602;
                checker = new TagChecker(tagId, new class_2487());
            } else {
                class_2960 class_29603 = class_2960.method_12829((String)jsonString);
                if (class_29603 == null) {
                    throw new IllegalStateException("Error in FzzyIngredient: Unparseable item identifier: " + jsonString);
                }
                class_2960 itemId = class_29603;
                checker = new ItemChecker(itemId, new class_2487());
            }
            return checker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u001b\u0010\u0012\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$ItemChecker;", "Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Checker;", "Lnet/minecraft/class_1799;", "stack", "", "check", "(Lnet/minecraft/class_1799;)Z", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2960;", "item", "Lnet/minecraft/class_2960;", "Lnet/minecraft/class_1792;", "itemCached$delegate", "Lkotlin/Lazy;", "getItemCached", "()Lnet/minecraft/class_1792;", "itemCached", "Lnet/minecraft/class_2487;", "nbt", "Lnet/minecraft/class_2487;", "<init>", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2487;)V", "fzzy_core"})
    private static final class ItemChecker
    implements Checker {
        @NotNull
        private final class_2960 item;
        @NotNull
        private final class_2487 nbt;
        @NotNull
        private final Lazy itemCached$delegate;

        public ItemChecker(@NotNull class_2960 item, @NotNull class_2487 nbt) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            this.item = item;
            this.nbt = nbt;
            this.itemCached$delegate = LazyKt.lazy((Function0)((Function0)new Function0<class_1792>(this){
                final /* synthetic */ ItemChecker this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final class_1792 invoke() {
                    Object object = class_7923.field_41178.method_10223(ItemChecker.access$getItem$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(item)");
                    return (class_1792)object;
                }
            }));
        }

        private final class_1792 getItemCached() {
            Lazy lazy = this.itemCached$delegate;
            return (class_1792)lazy.getValue();
        }

        @Override
        public boolean check(@NotNull class_1799 stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (!stack.method_31574(this.getItemCached())) {
                return false;
            }
            class_2487 class_24872 = stack.method_7969();
            if (class_24872 == null) {
                return this.nbt.method_33133();
            }
            class_2487 stackNbt = class_24872;
            return class_2512.method_10687((class_2520)((class_2520)this.nbt), (class_2520)((class_2520)stackNbt), (boolean)true);
        }

        @NotNull
        public String toString() {
            return "ItemChecker[item: " + this.item + ", nbt: " + this.nbt + "]";
        }

        public static final /* synthetic */ class_2960 access$getItem$p(ItemChecker $this) {
            return $this.item;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$TagChecker;", "Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Checker;", "Lnet/minecraft/class_1799;", "stack", "", "check", "(Lnet/minecraft/class_1799;)Z", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2487;", "nbt", "Lnet/minecraft/class_2487;", "Lnet/minecraft/class_2960;", "tag", "Lnet/minecraft/class_2960;", "Lnet/minecraft/class_6862;", "Lnet/minecraft/class_1792;", "tagCached$delegate", "Lkotlin/Lazy;", "getTagCached", "()Lnet/minecraft/class_6862;", "tagCached", "<init>", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2487;)V", "fzzy_core"})
    private static final class TagChecker
    implements Checker {
        @NotNull
        private final class_2960 tag;
        @NotNull
        private final class_2487 nbt;
        @NotNull
        private final Lazy tagCached$delegate;

        public TagChecker(@NotNull class_2960 tag, @NotNull class_2487 nbt) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            this.tag = tag;
            this.nbt = nbt;
            this.tagCached$delegate = LazyKt.lazy((Function0)((Function0)new Function0<class_6862<class_1792>>(this){
                final /* synthetic */ TagChecker this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final class_6862<class_1792> invoke() {
                    return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)TagChecker.access$getTag$p(this.this$0));
                }
            }));
        }

        private final class_6862<class_1792> getTagCached() {
            Lazy lazy = this.tagCached$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-tagCached>(...)");
            return (class_6862)object;
        }

        @Override
        public boolean check(@NotNull class_1799 stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (!stack.method_31573(this.getTagCached())) {
                return false;
            }
            class_2487 class_24872 = stack.method_7969();
            if (class_24872 == null) {
                return this.nbt.method_33133();
            }
            class_2487 stackNbt = class_24872;
            return class_2512.method_10687((class_2520)((class_2520)this.nbt), (class_2520)((class_2520)stackNbt), (boolean)true);
        }

        @NotNull
        public String toString() {
            return "TagChecker[tag: " + this.tag + ", nbt: " + this.nbt + "]";
        }

        public static final /* synthetic */ class_2960 access$getTag$p(TagChecker $this) {
            return $this.tag;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lme/fzzyhmstrs/fzzy_core/item_util/FzzyIngredient$Checker;", "", "Lnet/minecraft/class_1799;", "stack", "", "check", "(Lnet/minecraft/class_1799;)Z", "fzzy_core"})
    private static interface Checker {
        public boolean check(@NotNull class_1799 var1);
    }
}

