/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.cna.CNARenderTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.connector.Wire;
import org.antarcticgardens.cna.content.electricity.connector.WireSection;
import org.antarcticgardens.cna.content.electricity.wire.ElectricWireItem;
import org.antarcticgardens.cna.content.electricity.wire.WireType;
import org.antarcticgardens.cna.util.RaycastUtil;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ElectricalConnectorRenderer
implements BlockEntityRenderer<ElectricalConnectorBlockEntity> {
    public ElectricalConnectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ElectricalConnectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderAllConnections(blockEntity, poseStack, buffer);
        this.renderHand(blockEntity, partialTick, poseStack, buffer);
    }

    public void renderAllConnections(ElectricalConnectorBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer) {
        blockEntity.getConnectorPositions().entrySet().stream().forEach(e -> this.renderConnection(blockEntity.m_58899_(), (BlockPos)e.getKey(), (WireType)((Object)((Object)e.getValue())), poseStack, buffer, blockEntity.m_58904_()));
    }

    public boolean shouldRenderConnection(BlockPos pos, BlockPos endPos) {
        if (pos.m_123341_() < endPos.m_123341_()) {
            return true;
        }
        if (pos.m_123341_() == endPos.m_123341_()) {
            if (pos.m_123342_() < endPos.m_123342_()) {
                return true;
            }
            if (pos.m_123342_() == endPos.m_123342_() && pos.m_123343_() < endPos.m_123343_()) {
                return true;
            }
        }
        return false;
    }

    public void renderConnection(BlockPos pos, BlockPos endPos, WireType wireType, PoseStack poseStack, MultiBufferSource buffer, Level level) {
        if (!this.shouldRenderConnection(pos, endPos)) {
            return;
        }
        ResourceLocation texture = wireType.getTextureLocation();
        double distance = pos.m_252807_().m_82554_(endPos.m_252807_());
        int sections = (int)Math.ceil(distance * (double)((Integer)CNAConfig.getClient().wireSectionsPerMeter.get()).intValue());
        Vector3f direction = endPos.m_252807_().m_82546_(pos.m_252807_()).m_82541_().m_252839_();
        Wire wire = new Wire(direction, (float)distance, sections);
        VertexConsumer consumer = buffer.m_6299_(CNARenderTypes.wire(texture));
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252931_(new Matrix4f().rotateTowards((Vector3fc)wire.getDirection(), (Vector3fc)wire.getUp()));
        for (int i = 0; i < wire.getSections().size(); ++i) {
            Pair<WireSection, Float> pair = wire.getSections().get(i);
            float sectionOffset = wire.getSectionLength() * (float)i;
            Vector3f lightPos = pos.m_252807_().m_252839_().add((Vector3fc)wire.getDirection().mul(sectionOffset)).add((Vector3fc)wire.getUp().mul(((Float)pair.getSecond()).floatValue()));
            BlockPos lightBlockPos = BlockPos.m_274446_((Position)new Vec3(lightPos));
            int block = level.m_45517_(LightLayer.BLOCK, lightBlockPos);
            int sky = level.m_45517_(LightLayer.SKY, lightBlockPos);
            ((WireSection)pair.getFirst()).render(consumer, poseStack, LightTexture.m_109885_((int)block, (int)sky), ((Float)pair.getSecond()).floatValue());
            poseStack.m_252880_(0.0f, 0.0f, wire.getSectionLength());
        }
        poseStack.m_85849_();
    }

    public void renderHand(ElectricalConnectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            ElectricWireItem wireItem;
            BlockPos bound;
            Item item;
            ItemStack itemInHand = player.m_21205_();
            if (!(itemInHand.m_41720_() instanceof ElectricWireItem)) {
                itemInHand = player.m_21206_();
            }
            if ((item = itemInHand.m_41720_()) instanceof ElectricWireItem && (bound = (wireItem = (ElectricWireItem)item).getBoundConnector(itemInHand)) != null && bound.equals((Object)blockEntity.m_58899_())) {
                int maxDistance;
                Vec3 eyePos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                Vec3 endPos = eyePos.m_82549_(player.m_20252_(partialTick).m_82541_().m_82490_(2.0));
                HitResult hit = RaycastUtil.pickBlockFromPos(blockEntity.m_58904_(), eyePos, player.m_20252_(partialTick), Minecraft.m_91087_().f_91072_.m_105286_());
                if (hit instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    Vec3 vec = eyePos.m_82549_(blockHit.m_82450_().m_82546_(eyePos).m_82490_((double)0.9f));
                    if (eyePos.m_82554_(endPos) > eyePos.m_82554_(vec)) {
                        endPos = vec;
                    }
                }
                BlockPos pos = blockEntity.m_58899_();
                Vector3f to = new Vector3f((float)(endPos.f_82479_ - (double)pos.m_123341_() - 0.5), (float)(endPos.f_82480_ - (double)pos.m_123342_() - 0.5), (float)(endPos.f_82481_ - (double)pos.m_123343_() - 0.5));
                double distance = endPos.m_82554_(bound.m_252807_());
                if (distance > (double)((maxDistance = ((Integer)CNAConfig.getCommon().maxWireLength.get()).intValue()) * 2)) {
                    return;
                }
                if (Minecraft.m_91087_().f_91072_ != null && hit instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    BlockEntity blockEntity2 = blockEntity.m_58904_().m_7702_(blockHit.m_82425_());
                    if (blockEntity2 instanceof ElectricalConnectorBlockEntity) {
                        ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity2;
                        if (connector.isConnected(blockEntity.m_58899_())) {
                            return;
                        }
                        to = new Vector3f((float)(blockHit.m_82425_().m_123341_() - pos.m_123341_()), (float)(blockHit.m_82425_().m_123342_() - pos.m_123342_()), (float)(blockHit.m_82425_().m_123343_() - pos.m_123343_()));
                        distance = connector.m_58899_().m_252807_().m_82554_(blockEntity.m_58899_().m_252807_());
                    }
                }
                ResourceLocation texture = wireItem.getWireType().getTextureLocation();
                if (distance >= (double)maxDistance) {
                    texture = new ResourceLocation("create_new_age", "textures/wire/red.png");
                }
                int sections = (int)Math.ceil(distance * (double)((Integer)CNAConfig.getClient().wireSectionsPerMeter.get()).intValue());
                Vector3f direction = new Vector3f((Vector3fc)to).normalize();
                Wire wire = new Wire(direction, (float)distance, sections);
                VertexConsumer consumer = buffer.m_6299_(CNARenderTypes.wire(texture));
                poseStack.m_85836_();
                poseStack.m_252880_(0.5f, 0.5f, 0.5f);
                poseStack.m_252931_(new Matrix4f().rotateTowards((Vector3fc)wire.getDirection(), (Vector3fc)wire.getUp()));
                for (int i = 0; i < wire.getSections().size(); ++i) {
                    Pair<WireSection, Float> pair = wire.getSections().get(i);
                    float sectionOffset = wire.getSectionLength() * (float)i;
                    Vector3f lightPos = blockEntity.m_58899_().m_252807_().m_252839_().add((Vector3fc)wire.getDirection().mul(sectionOffset)).add((Vector3fc)wire.getUp().mul(((Float)pair.getSecond()).floatValue()));
                    BlockPos lightBlockPos = BlockPos.m_274446_((Position)new Vec3(lightPos));
                    int block = blockEntity.m_58904_().m_45517_(LightLayer.BLOCK, lightBlockPos);
                    int sky = blockEntity.m_58904_().m_45517_(LightLayer.SKY, lightBlockPos);
                    ((WireSection)pair.getFirst()).render(consumer, poseStack, LightTexture.m_109885_((int)block, (int)sky), ((Float)pair.getSecond()).floatValue());
                    poseStack.m_252880_(0.0f, 0.0f, wire.getSectionLength());
                }
                poseStack.m_85849_();
            }
        }
    }

    public boolean shouldRenderOffScreen(ElectricalConnectorBlockEntity blockEntity) {
        return true;
    }
}

