/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebag.listeners;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.registry.Registries;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.items.TreasureBag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class KillRewarder {
    private static final Map<String, Supplier<TreasureBag>> REWARDS = Map.of("minecraft:elder_guardian", MajruszsDifficulty.ELDER_GUARDIAN_TREASURE_BAG_ITEM, "minecraft:ender_dragon", MajruszsDifficulty.ENDER_DRAGON_TREASURE_BAG_ITEM, "minecraft:warden", MajruszsDifficulty.WARDEN_TREASURE_BAG_ITEM, "minecraft:wither", MajruszsDifficulty.WITHER_TREASURE_BAG_ITEM);

    private static void markForReward(OnEntityDamaged data) {
        Serializables.modify((Object)new DamageInfo(), (Tag)EntityHelper.getOrCreateExtraTag((Entity)data.target), damageInfo -> damageInfo.uuids.add(data.attacker.m_20148_()));
    }

    private static void giveTreasureBag(OnEntityDied data) {
        TreasureBag treasureBag = REWARDS.get(Registries.ENTITY_TYPES.getId((Object)data.target.m_6095_()).toString()).get();
        ((DamageInfo)Serializables.read((Object)new DamageInfo(), (Tag)EntityHelper.getOrCreateExtraTag((Entity)data.target))).uuids.forEach(uuid -> {
            Player player = data.getLevel().m_46003_(uuid);
            if (player != null) {
                ItemHelper.giveToPlayer((ItemStack)new ItemStack((ItemLike)treasureBag), (Player)player);
            }
        });
    }

    static {
        OnEntityDamaged.listen(KillRewarder::markForReward).addCondition(Condition.isLogicalServer()).addCondition(data -> data.attacker instanceof Player).addCondition(data -> REWARDS.containsKey(Registries.ENTITY_TYPES.getId((Object)data.target.m_6095_()).toString()));
        OnEntityDied.listen(KillRewarder::giveTreasureBag).addCondition(Condition.isLogicalServer()).addCondition(data -> REWARDS.containsKey(Registries.ENTITY_TYPES.getId((Object)data.target.m_6095_()).toString()));
        Serializables.get(DamageInfo.class).define("TreasureBagPlayersToReward", Reader.list((IReader)Reader.uuid()), s -> new ArrayList<UUID>(s.uuids), (s, v) -> {
            s.uuids = new HashSet<UUID>((Collection<UUID>)v);
        });
    }

    private static class DamageInfo {
        public Set<UUID> uuids = new HashSet<UUID>();

        private DamageInfo() {
        }
    }
}

