/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

import com.majruszlibrary.entity.EffectHelper;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnChorusFruitEaten;
import com.majruszlibrary.events.OnEnderManAngered;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.OnLootingLevelGet;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.itemsets.ItemSet;
import com.majruszsdifficulty.itemsets.ItemSetBonus;
import com.majruszsdifficulty.itemsets.ItemSetRequirement;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnderiumSet {
    static final MobEffect[] EFFECTS = new MobEffect[]{MobEffects.f_19617_, MobEffects.f_19600_, MobEffects.f_19606_, MobEffects.f_19607_, MobEffects.f_19603_, MobEffects.f_19596_, MobEffects.f_19618_};
    static final ItemSetRequirement HELMET = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_HELMET_ITEM, EquipmentSlot.HEAD);
    static final ItemSetRequirement CHESTPLATE = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_CHESTPLATE_ITEM, EquipmentSlot.CHEST);
    static final ItemSetRequirement LEGGINGS = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_LEGGINGS_ITEM, EquipmentSlot.LEGS);
    static final ItemSetRequirement BOOTS = ItemSetRequirement.of(MajruszsDifficulty.ENDERIUM_BOOTS_ITEM, EquipmentSlot.FEET);
    static final ItemSetBonus ENDERMAN_PROTECTION = ItemSetBonus.requires(HELMET).component("majruszsdifficulty.sets.enderium.bonus_1", TextHelper.translatable((String)"item.majruszsdifficulty.enderium_helmet", (Object[])new Object[0]));
    static final ItemSetBonus END_LOOTING = ItemSetBonus.any(2).component("majruszsdifficulty.sets.enderium.bonus_2", new Object[0]);
    static final ItemSetBonus CHORUS_FRUIT = ItemSetBonus.any(3).component("majruszsdifficulty.sets.enderium.bonus_3", Items.f_42730_.m_41466_());
    static final ItemSetBonus VOID_PROTECTION = ItemSetBonus.any(4).component("majruszsdifficulty.sets.enderium.bonus_4", new Object[0]);
    static final ItemSet ITEM_SET = ItemSet.create().component("majruszsdifficulty.sets.enderium.name").format(ChatFormatting.DARK_PURPLE).require(HELMET, CHESTPLATE, LEGGINGS, BOOTS).bonus(ENDERMAN_PROTECTION, END_LOOTING, CHORUS_FRUIT, VOID_PROTECTION);

    private static void increaseLooting(OnLootingLevelGet data) {
        ++data.level;
    }

    private static void giveRandomEffect(OnChorusFruitEaten data) {
        List<MobEffect> notAppliedEffects = Stream.of(EFFECTS).filter(effect -> EffectHelper.getAmplifier(() -> effect, (LivingEntity)data.entity).isEmpty()).toList();
        if (notAppliedEffects.isEmpty()) {
            notAppliedEffects = List.of(EFFECTS);
        }
        data.entity.m_7292_(new MobEffectInstance((MobEffect)Random.next(notAppliedEffects), TimeHelper.toTicks((double)90.0), 0));
        data.cancelTeleport();
    }

    private static void cancelDeath(OnEntityDied data) {
        if (Side.isLogicalServer()) {
            ServerPlayer player = (ServerPlayer)data.target;
            LevelHelper.getSpawnPoint((ServerPlayer)player).map(spawnPoint -> new LevelHelper.SpawnPoint(spawnPoint.level, AnyPos.from((Vec3)spawnPoint.position).add((Number)0.0, (Number)0.5, (Number)0.0).vec3())).ifPresent(spawnPoint -> spawnPoint.teleport(player));
        }
        EntityHelper.cheatDeath((LivingEntity)data.target);
        data.target.m_20334_(0.0, 0.5, 0.0);
        data.cancelDeath();
    }

    static {
        OnEnderManAngered.listen(OnEnderManAngered::cancelAnger).addCondition(data -> ITEM_SET.canTrigger(ENDERMAN_PROTECTION, (LivingEntity)data.player));
        OnLootingLevelGet.listen(EnderiumSet::increaseLooting).addCondition(data -> data.source != null).addCondition(data -> data.source.m_7639_() instanceof LivingEntity).addCondition(data -> data.getLevel().m_46472_() == Level.f_46430_).addCondition(data -> ITEM_SET.canTrigger(END_LOOTING, (LivingEntity)data.source.m_7639_()));
        OnChorusFruitEaten.listen(EnderiumSet::giveRandomEffect).addCondition(data -> ITEM_SET.canTrigger(CHORUS_FRUIT, data.entity));
        OnEntityDied.listen(EnderiumSet::cancelDeath).addCondition(data -> ITEM_SET.canTrigger(VOID_PROTECTION, data.target)).addCondition(data -> data.target.m_20186_() < (double)(data.target.m_9236_().m_141937_() - 64)).addCondition(data -> data.source.m_276093_(DamageTypes.f_268724_));
    }
}

