/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnEntityModelSetup;
import com.majruszlibrary.events.OnItemRendered;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ScrollItem
extends Item {
    protected static final int MIN_DURATION = TimeHelper.toTicks((double)1.0);

    public ScrollItem() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        this.playSound(this::getPrepareSound, level, (LivingEntity)player, 1.0f);
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity entity) {
        this.useScroll(itemStack, level, entity, 1.0f);
        return itemStack;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int ticksLeft) {
        if (this.m_8105_(itemStack) - ticksLeft < MIN_DURATION) {
            this.disableItem(itemStack, entity, TimeHelper.toTicks((double)1.0));
            return;
        }
        float useRatio = Mth.m_14036_((float)(1.0f - (float)ticksLeft / (float)(this.m_8105_(itemStack) - MIN_DURATION)), (float)0.0f, (float)1.0f);
        this.useScroll(itemStack, level, entity, useRatio);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack itemStack) {
        return TimeHelper.toTicks((double)3.0);
    }

    protected void useScroll(ItemStack itemStack, Level level, LivingEntity entity, float useRatio) {
        this.disableItem(itemStack, entity, TimeHelper.toTicks((double)16.0));
        this.playSound(this::getCastSound, level, entity, 2.0f);
    }

    protected void disableItem(ItemStack itemStack, LivingEntity entity, int ticks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemHelper.addCooldown((Player)player, (int)ticks, (Item[])new Item[]{itemStack.m_41720_()});
        }
    }

    protected void playSound(Supplier<SoundEvent> sound, Level level, LivingEntity entity, float volumeScale) {
        SoundEmitter.of(sound).source(SoundSource.PLAYERS).volume(SoundEmitter.randomized((float)volumeScale)).position(entity.m_20182_()).emit(level);
    }

    protected abstract SoundEvent getPrepareSound();

    protected abstract SoundEvent getCastSound();

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void modify(OnEntityModelSetup data) {
            float ticks = (float)data.entity.m_21252_() + TimeHelper.getPartialTicks();
            data.model.f_102812_.f_104200_ = 5.0f;
            data.model.f_102812_.f_104202_ = 0.0f;
            data.model.f_102812_.f_104203_ = Mth.m_14089_((float)(ticks * 0.6662f)) * 0.25f;
            data.model.f_102812_.f_104204_ = 0.0f;
            data.model.f_102812_.f_104205_ = -2.3561945f;
            data.model.f_102811_.f_104200_ = -5.0f;
            data.model.f_102811_.f_104202_ = 0.0f;
            data.model.f_102811_.f_104203_ = Mth.m_14089_((float)(ticks * 0.6662f)) * 0.25f;
            data.model.f_102811_.f_104204_ = 0.0f;
            data.model.f_102811_.f_104205_ = 2.3561945f;
        }

        private static void modify(OnItemRendered data) {
            data.poseStack.m_85837_(0.0, -0.1 * Math.sin((float)Side.getLocalPlayer().m_21252_() + TimeHelper.getPartialTicks()), 0.0);
        }

        static {
            OnEntityModelSetup.listen(Client::modify).addCondition(data -> data.entity.m_6117_()).addCondition(data -> data.entity.m_21211_().m_41720_() instanceof ScrollItem);
            OnItemRendered.listen(Client::modify).addCondition(data -> data.player.m_6117_()).addCondition(data -> data.player.m_21211_().equals(data.itemStack)).addCondition(data -> data.itemStack.m_41720_() instanceof ScrollItem);
        }
    }
}

