/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EffectDef;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class MobsApplyEffects {
    private static List<ExtraEffectDef> EXTRA_EFFECTS = List.of(new ExtraEffectDef("expert", 0.25f, true, EntityType.f_20479_, new EffectDef(() -> MobEffects.f_19614_, 0, 7.0f)), new ExtraEffectDef("expert", 0.5f, true, EntityType.f_20526_, new EffectDef(() -> MobEffects.f_19597_, 0, 7.0f)), new ExtraEffectDef("master", 0.5f, true, EntityType.f_20521_, new EffectDef(() -> MobEffects.f_19610_, 0, 7.0f)), new ExtraEffectDef("master", 0.75f, true, EntityType.f_20509_, new EffectDef(() -> MobEffects.f_19620_, 0, 7.0f)));

    private static void tryToApply(OnEntityDamaged data) {
        GameStage gameStage = GameStageHelper.determineGameStage(data);
        float crd = (float)LevelHelper.getClampedRegionalDifficultyAt((Level)data.getLevel(), (BlockPos)data.target.m_20183_());
        for (ExtraEffectDef extraEffect : EXTRA_EFFECTS) {
            if (data.attacker.m_6095_() != extraEffect.entityType || extraEffect.requiredGameStage.getOrdinal() > gameStage.getOrdinal() || !Random.check((float)(extraEffect.isScaledByCrd ? extraEffect.chance * crd : extraEffect.chance))) continue;
            data.target.m_7292_(extraEffect.effect.toEffectInstance());
        }
    }

    static {
        OnEntityDamaged.listen(MobsApplyEffects::tryToApply).addCondition(Condition.isLogicalServer()).addCondition(data -> data.attacker != null);
        Serializables.getStatic(Config.Features.class).define("mobs_apply_effects", Reader.list((IReader)Reader.custom(ExtraEffectDef::new)), () -> EXTRA_EFFECTS, v -> {
            EXTRA_EFFECTS = v;
        });
        Serializables.get(ExtraEffectDef.class).define("required_game_stage", Reader.string(), s -> s.requiredGameStage.getId(), (s, v) -> {
            s.requiredGameStage = GameStageHelper.find(v);
        }).define("chance", Reader.number(), s -> Float.valueOf(s.chance), (s, v) -> {
            s.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), s -> s.isScaledByCrd, (s, v) -> {
            s.isScaledByCrd = v;
        }).define("entity_type", Reader.entityType(), s -> s.entityType, (s, v) -> {
            s.entityType = v;
        }).define("effect", Reader.custom(EffectDef::new), s -> s.effect, (s, v) -> {
            s.effect = v;
        });
    }

    public static class ExtraEffectDef {
        public GameStage requiredGameStage = GameStageHelper.find("normal");
        public float chance;
        public boolean isScaledByCrd;
        public EntityType<?> entityType;
        public EffectDef effect;

        public ExtraEffectDef(String gameStageId, float chance, boolean isScaledByCRD, EntityType<?> entityType, EffectDef effect) {
            this.requiredGameStage = GameStageHelper.find(gameStageId);
            this.chance = chance;
            this.isScaledByCrd = isScaledByCRD;
            this.entityType = entityType;
            this.effect = effect;
        }

        public ExtraEffectDef() {
        }
    }
}

