/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.animations.Animations;
import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.modhelper.Resource;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.bloodmoon.BloodMoonHelper;
import com.majruszsdifficulty.data.Config;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CursedArmor
extends Monster
implements IAnimableEntity {
    private static final Resource<AnimationsDef> ANIMATIONS = MajruszsDifficulty.HELPER.load("cursed_armor_animation", AnimationsDef.class);
    private static float ITEM_DROP_CHANCE = 0.2f;
    private static float NAME_CHANCE = 0.025f;
    private static List<String> NAMES = List.of("Freshah");
    private static List<LocationDef> LOCATIONS = List.of(new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_dungeon"), List.of(new ResourceLocation("chests/simple_dungeon")), 0.5f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_stronghold"), List.of(new ResourceLocation("chests/stronghold_corridor"), new ResourceLocation("chests/stronghold_crossing"), new ResourceLocation("chests/stronghold_library")), 0.4f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_portal"), List.of(new ResourceLocation("chests/ruined_portal")), 1.0f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_nether"), List.of(new ResourceLocation("chests/bastion_bridge"), new ResourceLocation("chests/bastion_hoglin_stable"), new ResourceLocation("chests/bastion_other"), new ResourceLocation("chests/bastion_treasure"), new ResourceLocation("chests/nether_bridge")), 0.25f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_end"), List.of(new ResourceLocation("chests/end_city_treasure")), 0.5f));
    private final Animations animations = Animations.create();

    public static EntityType<CursedArmor> createEntityType() {
        return EntityType.Builder.m_20704_(CursedArmor::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 1.9f).m_20712_("cursed_armor");
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22278_, 0.23).m_22268_(Attributes.f_22284_, 4.0).m_22265_();
    }

    public static boolean m_219013_(EntityType<? extends Monster> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        return Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)random) && BloodMoonHelper.isActive();
    }

    public CursedArmor(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public boolean m_6040_() {
        return true;
    }

    public int m_213860_() {
        return 7;
    }

    public AnimationsDef getAnimationsDef() {
        return (AnimationsDef)ANIMATIONS.get();
    }

    public Animations getAnimations() {
        return this.animations;
    }

    public void assemble() {
        if (this.animations.isEmpty()) {
            this.playAnimation("assemble").addCallback(27, () -> {
                Item patt8471$temp = this.m_6844_(EquipmentSlot.CHEST).m_41720_();
                if (patt8471$temp instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)patt8471$temp;
                    SoundEmitter.of((SoundEvent)armorItem.m_150681_()).source(SoundSource.HOSTILE).position(this.m_20182_()).emit(this.m_9236_());
                }
            });
        }
    }

    public void equip(LocationDef locationDef) {
        LootHelper.getLootTable((ResourceLocation)locationDef.loot).m_287195_(LootHelper.toGiftParams((Entity)this)).forEach(itemStack -> {
            if (itemStack.m_41720_() instanceof ShieldItem) {
                this.m_8061_(EquipmentSlot.OFFHAND, (ItemStack)itemStack);
            } else {
                ItemHelper.equip((Mob)this, (ItemStack)itemStack);
            }
        });
        EquipmentSlots.ALL.forEach(slot -> this.m_21409_((EquipmentSlot)slot, ITEM_DROP_CHANCE));
    }

    public boolean isAssembling() {
        return !this.animations.isEmpty();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AssembleGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    private static Optional<LocationDef> find(ResourceLocation chestId) {
        return LOCATIONS.stream().filter(locationDef -> locationDef.chests.stream().anyMatch(arg_0 -> ((ResourceLocation)chestId).equals(arg_0))).findFirst();
    }

    private static LocationDef getRandomLocationDef() {
        return (LocationDef)Random.next(LOCATIONS);
    }

    private static void spawnCursedArmor(OnLootGenerated data) {
        TimeHelper.nextTick(delay -> {
            CursedArmor cursedArmor = (CursedArmor)EntityHelper.createSpawner(MajruszsDifficulty.CURSED_ARMOR_ENTITY, (Level)data.getLevel()).position(CursedArmor.getSpawnPosition(data)).beforeEvent(entity -> {
                float yRot = BlockHelper.getState((Level)data.getLevel(), (Vec3)data.origin).m_61145_((Property)ChestBlock.f_51478_).map(Direction::m_122435_).orElse(Float.valueOf((float)Random.nextInt((int)0, (int)4) * 90.0f)).floatValue();
                entity.m_146922_(yRot);
                entity.m_5616_(yRot);
                entity.m_5618_(yRot);
            }).spawn();
            if (cursedArmor != null) {
                cursedArmor.assemble();
                cursedArmor.equip(CursedArmor.find(data.lootId).orElseThrow());
                Entity patt10948$temp = data.entity;
                if (patt10948$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt10948$temp;
                    TimeHelper.nextTick(subdelay -> player.m_6915_());
                }
            }
        });
    }

    private static void giveRandomArmor(OnEntitySpawned data) {
        CursedArmor cursedArmor = (CursedArmor)data.entity;
        if (cursedArmor.m_21207_() == 0.0f) {
            cursedArmor.assemble();
            cursedArmor.equip(CursedArmor.getRandomLocationDef());
        }
    }

    private static void setCustomName(OnEntitySpawned data) {
        data.entity.m_6593_((Component)TextHelper.literal((String)((String)Random.next(NAMES))));
    }

    private static Vec3 getSpawnPosition(OnLootGenerated data) {
        ServerLevel level = data.getServerLevel();
        Function<Float, Boolean> isAir = y -> BlockHelper.getState((Level)level, (Vec3)data.origin.m_82520_(0.0, (double)y.floatValue(), 0.0)).m_60795_();
        if (isAir.apply(Float.valueOf(1.0f)).booleanValue() && isAir.apply(Float.valueOf(2.0f)).booleanValue()) {
            return data.origin.m_82520_(0.0, 0.5, 0.0);
        }
        Vec3i offset = BlockHelper.getState((Level)level, (Vec3)data.origin).m_61145_((Property)ChestBlock.f_51478_).map(Direction::m_122436_).orElse(new Vec3i(1, 0, 0));
        return data.origin.m_82520_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
    }

    private static void spawnIdleParticles(OnEntityTicked data) {
        CursedArmor.spawnParticles(data, new Vec3(0.0, (double)data.entity.m_20206_() * 0.5, 0.0), 0.3, 1);
    }

    private static void spawnAssemblingParticles(OnEntityTicked data) {
        CursedArmor.spawnParticles(data, new Vec3(0.0, 0.0, 0.0), 0.6, 5);
    }

    private static void spawnParticles(OnEntityTicked data, Vec3 emitterOffset, double offsetMultiplier, int particlesCount) {
        ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123809_).position(data.entity.m_20182_().m_82549_(emitterOffset)).offset(() -> AnyPos.from((Number)Float.valueOf(data.entity.m_20205_()), (Number)Float.valueOf(data.entity.m_20206_()), (Number)Float.valueOf(data.entity.m_20205_())).mul((Number)offsetMultiplier).vec3()).speed(0.5f).count(particlesCount).emit(data.getLevel());
    }

    static {
        OnLootGenerated.listen(CursedArmor::spawnCursedArmor).addCondition(Condition.isLogicalServer()).addCondition(data -> data.getLevel() != null).addCondition(data -> data.origin != null).addCondition(data -> BlockHelper.getEntity((Level)data.getLevel(), (Vec3)data.origin) instanceof ChestBlockEntity).addCondition(data -> Random.check((float)CursedArmor.find(data.lootId).map(def -> Float.valueOf(def.chance)).orElse(Float.valueOf(0.0f)).floatValue()));
        OnEntitySpawned.listen(CursedArmor::giveRandomArmor).addCondition(Condition.isLogicalServer()).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity instanceof CursedArmor);
        OnEntitySpawned.listen(CursedArmor::setCustomName).addCondition(Condition.isLogicalServer()).addCondition(Condition.chance(() -> Float.valueOf(NAME_CHANCE))).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity instanceof CursedArmor);
        OnEntityTicked.listen(CursedArmor::spawnIdleParticles).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.2f)).addCondition(data -> data.entity instanceof CursedArmor);
        OnEntityTicked.listen(CursedArmor::spawnAssemblingParticles).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.2f)).addCondition(data -> {
            CursedArmor cursedArmor;
            LivingEntity patt5808$temp = data.entity;
            return patt5808$temp instanceof CursedArmor && (cursedArmor = (CursedArmor)patt5808$temp).isAssembling();
        });
        OnEntityPreDamaged.listen(OnEntityPreDamaged::cancelDamage).addCondition(data -> {
            CursedArmor cursedArmor;
            LivingEntity patt5980$temp = data.target;
            return patt5980$temp instanceof CursedArmor && (cursedArmor = (CursedArmor)patt5980$temp).isAssembling();
        });
        Serializables.getStatic(Config.Mobs.class).define("cursed_armor", CursedArmor.class);
        Serializables.getStatic(CursedArmor.class).define("item_drop_chance", Reader.number(), () -> Float.valueOf(ITEM_DROP_CHANCE), v -> {
            ITEM_DROP_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("custom_name_chance", Reader.number(), () -> Float.valueOf(NAME_CHANCE), v -> {
            NAME_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("custom_names", Reader.list((IReader)Reader.string()), () -> NAMES, v -> {
            NAMES = v;
        }).define("locations", Reader.list((IReader)Reader.custom(LocationDef::new)), () -> LOCATIONS, v -> {
            LOCATIONS = v;
        });
        Serializables.get(LocationDef.class).define("loot", Reader.location(), s -> s.loot, (s, v) -> {
            s.loot = v;
        }).define("chests", Reader.list((IReader)Reader.location()), s -> s.chests, (s, v) -> {
            s.chests = v;
        }).define("chance", Reader.number(), s -> Float.valueOf(s.chance), (s, v) -> {
            s.chance = v.floatValue();
        });
    }

    public static class LocationDef {
        public ResourceLocation loot;
        public List<ResourceLocation> chests;
        public float chance;

        public LocationDef(ResourceLocation loot, List<ResourceLocation> chests, float chance) {
            this.loot = loot;
            this.chests = chests;
            this.chance = chance;
        }

        public LocationDef() {
            this(null, List.of(), 0.0f);
        }
    }

    public static class AssembleGoal
    extends Goal {
        private final CursedArmor cursedArmor;

        public AssembleGoal(CursedArmor cursedArmor) {
            this.cursedArmor = cursedArmor;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.cursedArmor.isAssembling();
        }
    }
}

