/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.api.research.ModResearchEffects;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchEffect
implements IResearchEffect {
    private static final String TAG_ID = "id";
    private static final String TAG_DESC = "desc";
    private static final String TAG_SUBTITLE = "subtitle";
    private static final String TAG_EFFECT = "effect";
    private static final String TAG_DISPLAY_EFFECT = "display";
    private final ResourceLocation id;
    private final TranslatableContents name;
    private final TranslatableContents subtitle;
    private final double effect;
    private final double displayEffect;

    public GlobalResearchEffect(ResourceLocation id, String name, String subtitle, double effect, double displayEffect) {
        this.id = id;
        this.name = new TranslatableContents(name, null, List.of(Double.valueOf(displayEffect), Double.valueOf(effect), Long.valueOf(Math.round(displayEffect * 100.0)), Long.valueOf(Math.round(effect * 100.0))).toArray());
        this.subtitle = new TranslatableContents(subtitle, null, TranslatableContents.f_237494_);
        this.effect = effect;
        this.displayEffect = displayEffect;
    }

    public GlobalResearchEffect(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_(TAG_ID));
        this.effect = nbt.m_128459_(TAG_EFFECT);
        this.displayEffect = nbt.m_128459_(TAG_DISPLAY_EFFECT);
        this.name = new TranslatableContents(nbt.m_128461_(TAG_DESC), null, List.of(Double.valueOf(this.displayEffect), Double.valueOf(this.effect), Long.valueOf(Math.round(this.displayEffect * 100.0)), Long.valueOf(Math.round(this.effect * 100.0))).toArray());
        this.subtitle = new TranslatableContents(nbt.m_128461_(TAG_SUBTITLE), null, TranslatableContents.f_237494_);
    }

    @Override
    public ModResearchEffects.ResearchEffectEntry getRegistryEntry() {
        return (ModResearchEffects.ResearchEffectEntry)ModResearchEffects.globalResearchEffect.get();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TranslatableContents getName() {
        return this.name;
    }

    @Override
    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }

    @Override
    public double getEffect() {
        return this.effect;
    }

    @Override
    public boolean overrides(@NotNull IResearchEffect other) {
        return Math.abs(this.effect) > Math.abs(((GlobalResearchEffect)other).effect);
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_ID, this.id.toString());
        nbt.m_128359_(TAG_DESC, this.name.m_237508_());
        nbt.m_128359_(TAG_SUBTITLE, this.subtitle.m_237508_());
        nbt.m_128347_(TAG_EFFECT, this.effect);
        nbt.m_128347_(TAG_DISPLAY_EFFECT, this.displayEffect);
        return nbt;
    }
}

