/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WeatheredCopperPlacementHandler
implements IPlacementHandler {
    @Nullable
    private static BlockState getExpectedBlockState(Level world, BlockPos pos, BlockState blockState, boolean complete) {
        BlockState inWorldState = world.m_8055_(pos);
        if (complete) {
            return blockState;
        }
        Block block = inWorldState.m_60734_();
        if (!(block instanceof WeatheringCopper)) {
            return blockState;
        }
        WeatheringCopper inWorldCopper = (WeatheringCopper)block;
        if (!(blockState.m_60734_() instanceof WeatheringCopper) || !Objects.equals(WeatheringCopper.m_154897_((Block)inWorldState.m_60734_()), WeatheringCopper.m_154897_((Block)blockState.m_60734_()))) {
            return blockState;
        }
        Block currentBlock = blockState.m_60734_();
        while (currentBlock != null && !((WeatheringCopper.WeatherState)((WeatheringCopper)currentBlock).m_142297_()).equals((Object)inWorldCopper.m_142297_())) {
            currentBlock = WeatheringCopper.m_154904_((Block)currentBlock).orElse(null);
        }
        if (currentBlock == null) {
            return blockState;
        }
        return null;
    }

    public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
        return blockState.m_60734_() instanceof WeatheringCopper;
    }

    public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
        BlockState expectedBlockState = WeatheredCopperPlacementHandler.getExpectedBlockState(world, pos, blockState, complete);
        if (expectedBlockState == null) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!world.m_7731_(pos, expectedBlockState, 3)) {
            return IPlacementHandler.ActionProcessingResult.DENY;
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        BlockState expectedBlockState = WeatheredCopperPlacementHandler.getExpectedBlockState(world, pos, blockState, complete);
        return expectedBlockState != null ? List.of(BlockUtils.getItemStackFromBlockState((BlockState)expectedBlockState)) : List.of();
    }
}

