/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.postbox;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.core.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class PostBoxRequestMessage
extends AbstractBuildingServerMessage<PostBox> {
    private ItemStack itemStack;
    private boolean deliverAvailable;
    private int reqQuantity;

    public PostBoxRequestMessage() {
    }

    public PostBoxRequestMessage(@NotNull IBuildingView building, ItemStack itemStack, int quantity, boolean deliverAvailable) {
        super(building);
        this.itemStack = itemStack;
        this.reqQuantity = quantity;
        this.deliverAvailable = deliverAvailable;
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.writeBoolean(this.deliverAvailable);
        buf.writeInt(this.reqQuantity);
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.itemStack = buf.m_130267_();
        this.deliverAvailable = buf.readBoolean();
        this.reqQuantity = buf.readInt();
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, PostBox building) {
        int minCount = this.deliverAvailable ? 1 : this.reqQuantity;
        Stack requestStack = new Stack(this.itemStack, this.reqQuantity, minCount);
        building.createRequest(requestStack, false);
    }
}

