/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.tileentities.TileEntityScarecrow;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class FarmFieldPlotResizeMessage
implements IMessage {
    private int size;
    private Direction direction;
    private BlockPos position;

    public FarmFieldPlotResizeMessage() {
    }

    public FarmFieldPlotResizeMessage(int size, Direction direction, BlockPos position) {
        this.size = size;
        this.direction = direction;
        this.position = position;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        BlockEntity fieldBlock = ctxIn.getSender().f_19853_.m_7702_(this.position);
        if (fieldBlock instanceof TileEntityScarecrow) {
            TileEntityScarecrow scarecrow = (TileEntityScarecrow)fieldBlock;
            int currentSum = Arrays.stream(scarecrow.getFieldSize()).sum();
            int currentDirSize = scarecrow.getFieldSize()[this.direction.m_122416_()];
            if (this.size < 0 || this.size > currentDirSize && currentSum - currentDirSize + this.size > 20) {
                return;
            }
            scarecrow.setFieldSize(this.direction, this.size);
            IColony colony = scarecrow.getCurrentColony();
            if (colony != null) {
                colony.getBuildingManager().getMatchingBuildingExtension(f -> f.getBuildingExtensionType().equals(BuildingExtensionRegistries.farmField.get()) && f.getPosition().equals((Object)this.position)).map(m -> (FarmField)m).ifPresent(field -> field.setRadius(this.direction, this.size));
            }
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.size);
        buf.writeInt(this.direction.m_122416_());
        buf.m_130064_(this.position);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.size = buf.readInt();
        this.direction = Direction.m_122407_((int)buf.readInt());
        this.position = buf.m_130135_();
    }
}

