/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class BuildRequestMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private Mode mode;
    private BlockPos builder;

    public BuildRequestMessage() {
    }

    public BuildRequestMessage(@NotNull IBuildingView building, Mode mode, BlockPos builder) {
        super(building);
        this.mode = mode;
        this.builder = builder;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.mode = Mode.values()[buf.readInt()];
        this.builder = buf.m_130135_();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.m_130064_(this.builder);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        ServerPlayer player = ctxIn.getSender();
        if (building.isPendingConstruction()) {
            building.removeWorkOrder();
        } else {
            switch (this.mode) {
                case BUILD: {
                    building.requestUpgrade((Player)player, this.builder);
                    break;
                }
                case REPAIR: {
                    building.requestRepair(this.builder);
                    break;
                }
                case REMOVE: {
                    building.requestRemoval((Player)player, this.builder);
                    for (BlockPos childPos : building.getChildren()) {
                        IBuilding childBuilding = colony.getBuildingManager().getBuilding(childPos);
                        if (childBuilding == null) continue;
                        childBuilding.requestRemoval((Player)player, this.builder);
                    }
                    break;
                }
            }
        }
    }

    public static enum Mode {
        BUILD,
        REPAIR,
        REMOVE;

    }
}

