/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.eventbus.events.colony.ColonyTeamColorChangedModEvent;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TeamColonyColorChangeMessage
extends AbstractColonyServerMessage {
    private int colorOrdinal;

    public TeamColonyColorChangeMessage() {
    }

    public TeamColonyColorChangeMessage(int colorOrdinal, @NotNull IBuildingView building) {
        super(building.getColony());
        this.colorOrdinal = colorOrdinal;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.colorOrdinal = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colorOrdinal);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        colony.setColonyColor(ChatFormatting.values()[this.colorOrdinal]);
        IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyTeamColorChangedModEvent(colony));
    }
}

