/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.colony.Colony;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveBuildingMessage
implements IMessage {
    private int colonyId;
    private BlockPos buildingId;

    public ColonyViewRemoveBuildingMessage() {
    }

    public ColonyViewRemoveBuildingMessage(@NotNull Colony colony, BlockPos building) {
        this.colonyId = colony.getID();
        this.buildingId = building;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = buf.m_130135_();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.m_130064_(this.buildingId);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            IColonyManager.getInstance().handleColonyViewRemoveBuildingMessage(this.colonyId, this.buildingId, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        }
    }
}

