/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CircleParticleEffectMessage
implements IMessage {
    private static final Random RAND = new Random();
    private SimpleParticleType type;
    private double posX;
    private double posY;
    private double posZ;
    private int stage;

    public CircleParticleEffectMessage() {
    }

    public CircleParticleEffectMessage(Vec3 pos, SimpleParticleType type, int stage) {
        this.posX = pos.f_82479_;
        this.posY = pos.f_82480_ - 0.5;
        this.posZ = pos.f_82481_;
        this.stage = stage;
        this.type = type;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.stage = buf.readInt();
        this.type = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buf.m_130281_());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.stage);
        buf.m_130085_(ForgeRegistries.PARTICLE_TYPES.getKey((Object)this.type));
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        double x = 1.0 * Math.cos((double)this.stage * 45.0) + this.posX;
        double z = 1.0 * Math.sin((double)this.stage * 45.0) + this.posZ;
        for (int i = 0; i < 5; ++i) {
            Vec3 randomPos = new Vec3(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
            Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
            world.m_7106_((ParticleOptions)this.type, x + randomOffset.f_82479_, this.posY + randomOffset.f_82480_, z + randomOffset.f_82481_, randomPos.f_82479_, randomPos.f_82480_ + 0.05, randomPos.f_82481_);
        }
    }
}

