/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityColonySign;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemColonySign
extends BlockItem {
    public static final String TAG_COLONY = "colony";

    public ItemColonySign(Item.Properties properties) {
        super(ModBlocks.blockColonySign, properties.m_41487_(64));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack sign = ctx.m_43723_().m_21120_(ctx.m_43724_());
        CompoundTag compound = sign.m_41784_();
        BlockEntity entity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (ctx.m_43723_().m_6144_()) {
            if (state.m_60734_() == ModBlocks.blockHutGateHouse && entity instanceof TileEntityColonyBuilding) {
                TileEntityColonyBuilding buildingEntity = (TileEntityColonyBuilding)entity;
                if (!ctx.m_43725_().f_46443_) {
                    if (buildingEntity.getColony() == null) {
                        MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.m_43723_());
                        return InteractionResult.SUCCESS;
                    }
                    if (buildingEntity.getBuilding() != null && buildingEntity.getBuilding().getBuildingLevel() <= 0) {
                        MessageUtils.format("com.minecolonies.core.item.sign.badgatehouse", new Object[0]).sendTo(ctx.m_43723_());
                        return InteractionResult.SUCCESS;
                    }
                    if (compound.m_128441_(TAG_COLONY) && compound.m_128451_(TAG_COLONY) != buildingEntity.getColonyId()) {
                        IColony sourceColony = IColonyManager.getInstance().getColonyByDimension(compound.m_128451_(TAG_COLONY), (ResourceKey<Level>)ctx.m_43725_().m_46472_());
                        if (sourceColony == null) {
                            MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.m_43723_());
                            return InteractionResult.SUCCESS;
                        }
                        if (!sourceColony.getPermissions().hasPermission(ctx.m_43723_(), Action.MANAGE_HUTS)) {
                            MessageUtils.format("com.minecolonies.core.item.sign.noperm", buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
                            return InteractionResult.SUCCESS;
                        }
                        sourceColony.getConnectionManager().attemptEstablishConnection(ctx.m_8083_(), buildingEntity.getColony());
                        return InteractionResult.SUCCESS;
                    }
                    if (buildingEntity.getColony().getPermissions().hasPermission(ctx.m_43723_(), Action.MANAGE_HUTS)) {
                        compound.m_128405_(TAG_COLONY, buildingEntity.getColonyId());
                        BlockPosUtil.write(compound, "pos", ctx.m_8083_());
                        MessageUtils.format("com.minecolonies.core.item.sign.registered", buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
                    } else {
                        MessageUtils.format("com.minecolonies.core.item.sign.noperm", buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (entity instanceof TileEntityColonySign) {
                TileEntityColonySign signEntity = (TileEntityColonySign)entity;
                if (!ctx.m_43725_().f_46443_) {
                    IColony colony = IColonyManager.getInstance().getColonyByDimension(signEntity.getColonyId(), (ResourceKey<Level>)ctx.m_43725_().m_46472_());
                    if (colony == null) {
                        MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.m_43723_());
                        return InteractionResult.SUCCESS;
                    }
                    if (compound.m_128441_(TAG_COLONY) && compound.m_128451_(TAG_COLONY) != signEntity.getColonyId()) {
                        IColony sourceColony = IColonyManager.getInstance().getColonyByDimension(compound.m_128451_(TAG_COLONY), (ResourceKey<Level>)ctx.m_43725_().m_46472_());
                        if (sourceColony == null) {
                            MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.m_43723_());
                            return InteractionResult.SUCCESS;
                        }
                        if (!sourceColony.getPermissions().hasPermission(ctx.m_43723_(), Action.MANAGE_HUTS)) {
                            MessageUtils.format("com.minecolonies.core.item.sign.noperm", sourceColony.getName()).sendTo(ctx.m_43723_());
                            return InteractionResult.SUCCESS;
                        }
                        sourceColony.getConnectionManager().attemptEstablishConnection(ctx.m_8083_(), colony);
                        return InteractionResult.SUCCESS;
                    }
                    if (colony.getPermissions().hasPermission(ctx.m_43723_(), Action.MANAGE_HUTS)) {
                        compound.m_128405_(TAG_COLONY, signEntity.getColonyId());
                        BlockPosUtil.write(compound, "pos", ctx.m_8083_());
                        MessageUtils.format("com.minecolonies.core.item.sign.registered", colony.getName()).sendTo(ctx.m_43723_());
                    } else {
                        MessageUtils.format("com.minecolonies.core.item.sign.noperm", colony.getName()).sendTo(ctx.m_43723_());
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(ctx);
    }

    protected boolean m_40610_(BlockPlaceContext ctx, BlockState state) {
        if (!super.m_40610_(ctx, state)) {
            return false;
        }
        if (!ctx.m_43722_().m_41784_().m_128441_(TAG_COLONY)) {
            if (ctx.m_43725_().f_46443_) {
                MessageUtils.format("com.minecolonies.core.item.sign.needcolony", new Object[0]).sendTo(ctx.m_43723_());
            }
            return false;
        }
        if (!ctx.m_43725_().f_46443_) {
            int colonyId = ctx.m_43722_().m_41783_().m_128451_(TAG_COLONY);
            IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)ctx.m_43725_().m_46472_());
            if (colony == null) {
                MessageUtils.format("com.minecolonies.core.item.sign.needcolony", new Object[0]).sendTo(ctx.m_43723_());
                return false;
            }
            if (colony.getConnectionManager().addNewConnectionNode(ctx.m_8083_())) {
                SoundUtils.playSuccessSound(ctx.m_43723_(), ctx.m_8083_());
                return true;
            }
            SoundUtils.playErrorSound(ctx.m_43723_(), ctx.m_8083_());
            return false;
        }
        return true;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (stack.m_41784_().m_128441_(TAG_COLONY)) {
            MutableComponent colonyHint = Component.m_237110_((String)"com.minecolonies.core.item.colonysign.tip.colony", (Object[])new Object[]{stack.m_41784_().m_128451_(TAG_COLONY)});
            colonyHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_BLUE));
            tooltip.add((Component)colonyHint);
        }
        MutableComponent guiHint = Component.m_237115_((String)"com.minecolonies.core.item.colonysign.tip");
        guiHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

