/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.managers.interfaces.IManagedAnimal;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.entity.mobs.IAnimalColonyHandler;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnimalColonyHandler
implements IAnimalColonyHandler {
    protected boolean registered = false;
    @Nullable
    protected IColony colony;
    protected int colonyId = 0;
    private boolean needsClientUpdate = false;
    protected final IManagedAnimal<? extends Entity> animal;

    public AnimalColonyHandler(IManagedAnimal<? extends Entity> managedAnimal) {
        this.animal = managedAnimal;
    }

    @Override
    public void registerWithColony(int registeringToColony, int animalID) {
        if (this.registered) {
            return;
        }
        this.colonyId = registeringToColony;
        this.animal.setManagedAnimalId(animalID);
        if (this.colonyId == 0 || this.animal.getManagedAnimalId() == 0) {
            Log.getLogger().warn(String.format("IManagedAnimal '%s' has an unassigned colony id (#%d) or animal id (#%d)", this.animal.getEntity().m_20148_(), this.colonyId, this.animal.getManagedAnimalId()));
            this.animal.getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.animal.getEntity().m_9236_());
        if (colony == null) {
            Log.getLogger().warn(String.format("IManagedAnimal '%s' unable to find Colony #%d", this.animal.getEntity().m_20148_(), this.colonyId));
            this.animal.getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.colony = colony;
        colony.getAnimalManager().registerAnimal(this.animal);
        this.registered = true;
    }

    @Override
    @Nullable
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public void setColonyId(int colonyId) {
        if (colonyId != this.colonyId) {
            this.colony = IColonyManager.getInstance().getColonyByWorld(colonyId, this.animal.getEntity().m_9236_());
        }
        this.colonyId = colonyId;
    }

    @Override
    public void updateColonyClient() {
        if (this.needsClientUpdate) {
            if (this.colonyId == 0) {
                this.colonyId = (Integer)this.animal.getEntity().m_20088_().m_135370_(this.animal.getColonyIdAccessor());
            }
            if (this.colonyId == 0) {
                this.animal.getEntity().m_146870_();
                return;
            }
            this.colony = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)this.animal.getEntity().m_9236_().m_46472_());
            if (this.animal.getManagedAnimalId() == 0) {
                this.animal.setManagedAnimalId((Integer)this.animal.getEntity().m_20088_().m_135370_(this.animal.getAnimalIdAccessor()));
            }
            this.needsClientUpdate = false;
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (data.equals(this.animal.getAnimalIdAccessor()) || data.equals(this.animal.getColonyIdAccessor())) {
            this.needsClientUpdate = true;
        }
    }
}

