/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.messages;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.Network;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.debug.messages.DebugOutputMessage;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class QueryCitizenAIHistoryMessage
extends AbstractColonyServerMessage {
    private int id;

    public QueryCitizenAIHistoryMessage() {
    }

    public QueryCitizenAIHistoryMessage(ICitizenDataView citizen) {
        super(citizen.getColony());
        this.id = citizen.getId();
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.id = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null || !DebugPlayerManager.hasDebugEnabled((Player)player)) {
            return;
        }
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.id);
        if (citizen == null || !citizen.getEntity().isPresent()) {
            return;
        }
        AbstractEntityCitizen abstractEntityCitizen = citizen.getEntity().get();
        if (abstractEntityCitizen instanceof EntityCitizen) {
            EntityCitizen entityCitizen = (EntityCitizen)abstractEntityCitizen;
            MutableComponent message = Component.m_237113_((String)"Citizen AI: ").m_7220_(entityCitizen.getCitizenAI().getHistory());
            if (entityCitizen.getCitizenJobHandler().getColonyJob() != null) {
                message.m_7220_((Component)Component.m_237113_((String)"Job AI: ").m_7220_(entityCitizen.getCitizenJobHandler().getWorkAI().getStateAI().getHistory()));
            }
            Network.getNetwork().sendToPlayer(new DebugOutputMessage((Component)message, true), ctxIn.getSender());
        }
    }
}

