/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.command;

import com.minecolonies.core.Network;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.debug.messages.DebugEnableMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandToggleDebug
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        GameProfile profile;
        try {
            profile = GameProfileArgument.m_94590_(context, (String)"playername").stream().findFirst().orElse(null);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        boolean enabled = DebugPlayerManager.toggleDebugModeFor(profile.getId());
        if (enabled) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Enabled minecolonies debugging for:" + profile.getName())).m_130940_(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Disabled minecolonies debugging for:" + profile.getName())).m_130940_(ChatFormatting.RED), true);
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(profile.getId());
        if (player != null) {
            if (enabled) {
                Network.getNetwork().sendToPlayer(new DebugEnableMessage(true), player);
                player.m_213846_((Component)Component.m_237113_((String)"Enabled minecolonies debugging").m_130940_(ChatFormatting.GREEN));
            } else {
                Network.getNetwork().sendToPlayer(new DebugEnableMessage(false), player);
                player.m_213846_((Component)Component.m_237113_((String)"Disabled minecolonies debugging").m_130940_(ChatFormatting.RED));
            }
        }
        return 1;
    }

    @Override
    public String getName() {
        return "toggleDebugging";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("playername", GameProfileArgument.m_94584_()).executes(this::checkPreConditionAndExecute));
    }
}

