/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;

public class CommandColonyChunks
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        HashSet<TicketType> types = new HashSet<TicketType>();
        for (Long chunkLong : colony.getLoadedChunks()) {
            SortedArraySet tickets = (SortedArraySet)((CommandSourceStack)context.getSource()).m_81372_().m_7726_().f_8325_.m_143145_().f_140761_.get(chunkLong.longValue());
            if (tickets == null) continue;
            for (Ticket ticket : tickets) {
                types.add(ticket.m_9428_());
            }
        }
        StringBuilder ticketString = new StringBuilder();
        for (TicketType type : types) {
            ticketString.append("[").append(type).append("]");
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"ID: ").m_7220_((Component)Component.m_237113_((String)("" + colony.getID())).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" Name: ")).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.YELLOW)), true);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Loaded chunks:").m_7220_((Component)Component.m_237113_((String)(" " + colony.getLoadedChunkCount())).m_130940_(ChatFormatting.YELLOW)), true);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"Ticket types: ").m_7220_((Component)Component.m_237113_((String)ticketString.toString()).m_130940_(ChatFormatting.YELLOW)), true);
        return 1;
    }

    @Override
    public String getName() {
        return "chunkstatus";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).executes(this::checkPreConditionAndExecute));
    }
}

