/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class CommandCitizenTeleport
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notloaded"), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        Coordinates targetLocation = Vec3Argument.m_120849_(context, (String)"location");
        BlockPos targetPos = targetLocation.m_119568_((CommandSourceStack)context.getSource());
        if (((CommandSourceStack)context.getSource()).m_81372_() == entityCitizen.f_19853_) {
            entityCitizen.m_7678_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), entityCitizen.m_5675_(1.0f), entityCitizen.m_5686_(1.0f));
            entityCitizen.getNavigation().m_26573_();
        }
        return 1;
    }

    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("location", Vec3Argument.m_120841_()).executes(this::checkPreConditionAndExecute))));
    }
}

