/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLLoader;

public abstract class MultipleOptionsArgument<TValue>
implements ArgumentType<OptionContainer<TValue>> {
    private final List<ArgumentOption<TValue>> allowedOptions;

    protected MultipleOptionsArgument(List<ArgumentOption<TValue>> allowedOptions) {
        this.allowedOptions = allowedOptions;
    }

    protected static <TValue> TValue getValue(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        OptionContainer container = (OptionContainer)context.getArgument(name, OptionContainer.class);
        return container.option.resolveValue((CommandSourceStack)context.getSource(), container.value);
    }

    public final OptionContainer<TValue> parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead()) {
            Object argumentValue;
            if (reader.peek() == '@') {
                reader.skip();
                argumentValue = "@" + reader.readString();
            } else {
                argumentValue = reader.readString();
            }
            for (ArgumentOption<TValue> allowedOption : this.allowedOptions) {
                if (!allowedOption.matches((String)argumentValue)) continue;
                return new OptionContainer<TValue>(allowedOption, (String)argumentValue);
            }
            throw EntitySelectorParser.f_121191_.createWithContext((ImmutableStringReader)reader, argumentValue);
        }
        throw EntitySelectorParser.f_121193_.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Iterator<ArgumentOption<TValue>> iterator = context.getSource();
        if (iterator instanceof CommandSourceStack) {
            CommandSourceStack source = (CommandSourceStack)iterator;
            for (ArgumentOption<TValue> allowedOption : this.allowedOptions) {
                allowedOption.createSuggestions((Level)source.m_81372_(), (SharedSuggestionProvider)source, builder);
            }
        } else if (FMLLoader.getDist().isClient()) {
            ClientSuggester.loadClientSuggestions(context.getSource(), builder, this.allowedOptions);
        }
        return builder.buildFuture();
    }

    public record OptionContainer<TValue>(ArgumentOption<TValue> option, String value) {
    }

    public static interface ArgumentOption<TValue> {
        public boolean matches(String var1);

        public TValue resolveValue(CommandSourceStack var1, String var2) throws CommandSyntaxException;

        public void createSuggestions(Level var1, SharedSuggestionProvider var2, SuggestionsBuilder var3);
    }

    private static class ClientSuggester {
        private ClientSuggester() {
        }

        private static <TValue> void loadClientSuggestions(Object source, SuggestionsBuilder builder, List<ArgumentOption<TValue>> allowedOptions) {
            if (source instanceof ClientSuggestionProvider) {
                ClientSuggestionProvider clientSuggestionProvider = (ClientSuggestionProvider)source;
                for (ArgumentOption<TValue> allowedOption : allowedOptions) {
                    allowedOption.createSuggestions((Level)Minecraft.m_91087_().f_91073_, (SharedSuggestionProvider)clientSuggestionProvider, builder);
                }
            }
        }
    }
}

