/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEntitySpawnEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IEventStructureManager;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.managers.EventStructureManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class EventManager
implements IEventManager {
    private static final String TAG_EVENT_ID = "event_currentID";
    private static final String TAG_EVENT_MANAGER = "event_manager";
    private static final String TAG_EVENT_LIST = "events_list";
    private int currentEventID = 1;
    private final IColony colony;
    private final Map<Integer, IColonyEvent> events = new HashMap<Integer, IColonyEvent>();
    private final EventStructureManager structureManager;

    public EventManager(IColony colony) {
        this.colony = colony;
        this.structureManager = new EventStructureManager(this, colony);
    }

    @Override
    public void addEvent(IColonyEvent colonyEvent) {
        if (colonyEvent.getID() == 0) {
            Log.getLogger().warn("missing ID for event:" + colonyEvent.getEventTypeID().m_135815_());
            return;
        }
        this.events.put(colonyEvent.getID(), colonyEvent);
        this.colony.markDirty();
    }

    @Override
    public int getAndTakeNextEventID() {
        if (this.currentEventID > 2147483547) {
            this.currentEventID = 1;
        }
        ++this.currentEventID;
        this.colony.markDirty();
        return this.currentEventID - 1;
    }

    @Override
    public void registerEntity(@NotNull Entity entity, int eventID) {
        IColonyEvent event = this.events.get(eventID);
        if (!(event instanceof IColonyEntitySpawnEvent)) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        ((IColonyEntitySpawnEvent)event).registerEntity(entity);
    }

    @Override
    public void unregisterEntity(@NotNull Entity entity, int eventID) {
        IColonyEvent event = this.events.get(eventID);
        if (event instanceof IColonyEntitySpawnEvent) {
            ((IColonyEntitySpawnEvent)event).unregisterEntity(entity);
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity, int eventID) {
        IColonyEvent event = this.events.get(eventID);
        if (event instanceof IColonyEntitySpawnEvent) {
            ((IColonyEntitySpawnEvent)event).onEntityDeath(entity);
        }
    }

    @Override
    public void onTileEntityBreak(int eventID, BlockEntity te) {
        IColonyEvent event = this.events.get(eventID);
        if (event != null) {
            event.onTileEntityBreak(te);
        }
    }

    @Override
    public void onNightFall() {
        for (IColonyEvent event : this.events.values()) {
            event.onNightFall();
        }
    }

    @Override
    public IColonyEvent getEventByID(int ID) {
        return this.events.get(ID);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        Iterator<IColonyEvent> iterator = this.events.values().iterator();
        while (iterator.hasNext()) {
            IColonyEvent event = iterator.next();
            if (event.getStatus() == EventStatus.DONE) {
                event.onFinish();
                this.structureManager.loadBackupForEvent(event.getID());
                colony.markDirty();
                iterator.remove();
                continue;
            }
            if (event.getStatus() == EventStatus.STARTING) {
                event.onStart();
                continue;
            }
            if (event.getStatus() == EventStatus.CANCELED) {
                colony.markDirty();
                iterator.remove();
                continue;
            }
            event.onUpdate();
        }
    }

    @Override
    public Map<Integer, IColonyEvent> getEvents() {
        return this.events;
    }

    @Override
    public void readFromNBT(@NotNull CompoundTag compound) {
        if (compound.m_128441_(TAG_EVENT_MANAGER)) {
            CompoundTag eventManagerNBT = compound.m_128469_(TAG_EVENT_MANAGER);
            ListTag eventListNBT = eventManagerNBT.m_128437_(TAG_EVENT_LIST, 10);
            for (Tag base : eventListNBT) {
                CompoundTag tagCompound = (CompoundTag)base;
                ResourceLocation eventTypeID = new ResourceLocation("minecolonies", tagCompound.m_128461_("name"));
                ColonyEventTypeRegistryEntry registryEntry = (ColonyEventTypeRegistryEntry)MinecoloniesAPIProxy.getInstance().getColonyEventRegistry().getValue(eventTypeID);
                if (registryEntry == null) {
                    Log.getLogger().warn("Event is missing registryEntry!:" + eventTypeID.m_135815_());
                    continue;
                }
                IColonyEvent colonyEvent = registryEntry.deserializeEvent(this.colony, tagCompound);
                this.events.put(colonyEvent.getID(), colonyEvent);
            }
            this.currentEventID = eventManagerNBT.m_128451_(TAG_EVENT_ID);
            this.structureManager.readFromNBT(compound);
        }
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compound) {
        CompoundTag eventManagerNBT = new CompoundTag();
        ListTag eventListNBT = new ListTag();
        for (IColonyEvent event : this.events.values()) {
            CompoundTag eventNBT = (CompoundTag)event.serializeNBT();
            eventNBT.m_128359_("name", event.getEventTypeID().m_135815_());
            eventListNBT.add((Object)eventNBT);
        }
        eventManagerNBT.m_128405_(TAG_EVENT_ID, this.currentEventID);
        eventManagerNBT.m_128365_(TAG_EVENT_LIST, (Tag)eventListNBT);
        compound.m_128365_(TAG_EVENT_MANAGER, (Tag)eventManagerNBT);
        this.structureManager.writeToNBT(compound);
    }

    @Override
    public IEventStructureManager getStructureManager() {
        return this.structureManager;
    }
}

