/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.colony.IAnimalData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.IAnimalManager;
import com.minecolonies.api.colony.managers.interfaces.IManagedAnimal;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.AnimalData;
import com.minecolonies.core.network.messages.client.colony.ColonyViewAnimalViewDataMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import org.jetbrains.annotations.NotNull;

public class AnimalManager
implements IAnimalManager {
    public static String TAG_ANIMAL_MANAGER = "animalManager";
    public static String TAG_ANIMALS = "animals";
    public static String TAG_NEXTID = "nextID";
    private Map<Integer, IAnimalData> animalMap = new HashMap<Integer, IAnimalData>();
    private boolean isDirty = false;
    private final IColony colony;
    private int nextAnimalID = -1;

    public AnimalManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public void registerAnimal(IManagedAnimal<? extends Animal> animal) {
        Animal animalEntity = animal.getEntity();
        if (animal.getManagedAnimalId() == 0 || this.animalMap.get(animal.getManagedAnimalId()) == null) {
            if (!animalEntity.isAddedToWorld()) {
                Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
            }
            animalEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        IAnimalData data = this.animalMap.get(animal.getManagedAnimalId());
        if (data == null || !animalEntity.m_20148_().equals(data.getUUID())) {
            if (!animalEntity.isAddedToWorld()) {
                Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
            }
            animalEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        Optional<IManagedAnimal<? extends Animal>> existingManagedAnimal = data.getManagedAnimal();
        if (!existingManagedAnimal.isPresent()) {
            data.setManagedAnimal(animal);
            animal.setAnimalData(data);
            return;
        }
        if (existingManagedAnimal.get() == animal) {
            return;
        }
        if (animalEntity.m_6084_()) {
            existingManagedAnimal.get().getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
            data.setManagedAnimal(animal);
            animal.setAnimalData(data);
            return;
        }
        if (!animalEntity.isAddedToWorld()) {
            Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
        }
        animalEntity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public List<IAnimalData> getAnimals() {
        return new ArrayList<IAnimalData>(this.animalMap.values());
    }

    @Override
    public int getCurrentAnimalCount() {
        return this.animalMap.size();
    }

    @Override
    public IAnimalData createAndRegisterAnimalData(IManagedAnimal<? extends Animal> managedAnimal) {
        if (this.colony == null) {
            Log.getLogger().warn("Missing colony while attempting to create and register managed animal data. This should not happen - report to devs." + String.valueOf(this), (Throwable)new Exception());
            return null;
        }
        if (this.getCurrentAnimalCount() == 0) {
            this.nextAnimalID = 1;
        } else {
            for (int i = 1; i <= this.getCurrentAnimalCount() + 1; ++i) {
                if (this.getAnimal(i) != null) continue;
                this.nextAnimalID = i;
                break;
            }
        }
        AnimalData animalData = new AnimalData(this.nextAnimalID, this.colony);
        this.animalMap.put(animalData.getId(), animalData);
        managedAnimal.setManagedAnimalId(animalData.getId());
        managedAnimal.getEntity().m_20088_().m_135381_(managedAnimal.getColonyIdAccessor(), (Object)this.colony.getID());
        animalData.setManagedAnimal(managedAnimal);
        return animalData;
    }

    @Override
    public IAnimalData getAnimal(int id) {
        return this.animalMap.get(id);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        if (!compound.m_128425_(TAG_ANIMAL_MANAGER, 10)) {
            return;
        }
        CompoundTag animalManagerNBT = compound.m_128469_(TAG_ANIMAL_MANAGER);
        this.animalMap.clear();
        this.nextAnimalID = animalManagerNBT.m_128425_(TAG_NEXTID, 3) ? animalManagerNBT.m_128451_(TAG_NEXTID) : 1;
        if (animalManagerNBT.m_128425_(TAG_ANIMALS, 9)) {
            ListTag animalList = animalManagerNBT.m_128437_(TAG_ANIMALS, 10);
            for (int i = 0; i < animalList.size(); ++i) {
                CompoundTag animalTag = animalList.m_128728_(i);
                try {
                    IAnimalData data = AnimalData.loadAnimalFromNBT(this.colony, animalTag);
                    if (data == null) {
                        Log.getLogger().warn("Skipped null animal data at index {} while reading animal manager.", (Object)i);
                        continue;
                    }
                    int id = data.getId();
                    IAnimalData prev = this.animalMap.put(id, data);
                    if (prev == null) continue;
                    Log.getLogger().warn("Duplicate animal id {} while reading animal manager; overwrote previous entry.", (Object)id);
                    continue;
                }
                catch (Exception e) {
                    Log.getLogger().error("Failed to load animal data at index {} in animal manager; skipping entry.", (Object)i, (Object)e);
                }
            }
        } else {
            Log.getLogger().warn("No animals list while reading animal manager; skipping.");
        }
    }

    @Override
    public void write(@NotNull CompoundTag compoundNBT) {
        CompoundTag animalManagerNBT = new CompoundTag();
        ListTag animalList = new ListTag();
        for (Map.Entry<Integer, IAnimalData> entry : this.animalMap.entrySet()) {
            animalList.add((Object)entry.getValue().serializeNBT());
        }
        animalManagerNBT.m_128365_(TAG_ANIMALS, (Tag)animalList);
        animalManagerNBT.m_128405_(TAG_NEXTID, this.nextAnimalID);
        compoundNBT.m_128365_(TAG_ANIMAL_MANAGER, (Tag)animalManagerNBT);
    }

    @Override
    public void onColonyTick(IColony colony) {
    }

    @Override
    public boolean tickAnimalData(int tickRate) {
        for (IAnimalData animalData : this.getAnimals()) {
            animalData.update(tickRate);
        }
        return false;
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    public void sendPackets(@NotNull Set<ServerPlayer> closeSubscribers, @NotNull Set<ServerPlayer> newSubscribers) {
        boolean refresh;
        HashSet<IAnimalData> toSend = null;
        boolean bl = refresh = !newSubscribers.isEmpty() || this.isDirty;
        if (refresh) {
            toSend = new HashSet<IAnimalData>(this.animalMap.values());
            for (IAnimalData data : this.animalMap.values()) {
                data.clearDirty();
            }
            this.clearDirty();
        } else {
            for (IAnimalData data : this.animalMap.values()) {
                if (data.isDirty()) {
                    if (toSend == null) {
                        toSend = new HashSet();
                    }
                    toSend.add(data);
                }
                data.clearDirty();
            }
        }
        if (toSend == null || toSend.isEmpty()) {
            return;
        }
        HashSet<ServerPlayer> players = new HashSet<ServerPlayer>(newSubscribers);
        players.addAll(closeSubscribers);
        ColonyViewAnimalViewDataMessage message = new ColonyViewAnimalViewDataMessage(this.colony, toSend, refresh);
        for (ServerPlayer player : players) {
            Network.getNetwork().sendToPlayer(message, player);
        }
    }
}

