/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid;

import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyCampFireRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.colony.events.raid.barbarianEvent.Horde;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.network.messages.client.PlayAudioMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public abstract class HordeRaidEvent
implements IColonyRaidEvent,
IColonyCampFireRaidEvent {
    private static final int WAYPOINT_SPACING = 20;
    public static int MAX_SPAWN_DEVIATION = 300;
    public static int MAX_RESPAWN_DEVIATION = 160;
    public static int MIN_CENTER_DISTANCE = 100;
    protected Horde horde;
    protected final ServerBossEvent raidBar = new ServerBossEvent((Component)Component.m_237113_((String)"Colony Raid"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    protected Map<Entity, UUID> normal = new WeakHashMap<Entity, UUID>();
    protected Map<Entity, UUID> archers = new WeakHashMap<Entity, UUID>();
    protected Map<Entity, UUID> boss = new WeakHashMap<Entity, UUID>();
    private List<Tuple<EntityType<?>, BlockPos>> respawns = new ArrayList();
    private List<BlockPos> campFires = new ArrayList<BlockPos>();
    private IColony colony;
    private int id;
    private BlockPos spawnPoint;
    protected EventStatus status = EventStatus.STARTING;
    private int daysToGo = 3;
    private int campFireTime = 0;
    private PathResult spawnPathResult;
    private List<BlockPos> wayPoints = new ArrayList<BlockPos>();

    public HordeRaidEvent(IColony colony) {
        this.colony = colony;
        this.id = colony.getEventManager().getAndTakeNextEventID();
    }

    @Override
    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.spawnPoint;
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        entities.addAll(this.archers.keySet());
        entities.addAll(this.boss.keySet());
        entities.addAll(this.normal.keySet());
        return entities;
    }

    @Override
    public EventStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setColony(@NotNull IColony colony) {
        this.colony = colony;
    }

    @Override
    public void unregisterEntity(Entity entity) {
        if (!this.archers.containsKey(entity) && !this.boss.containsKey(entity) && !this.normal.containsKey(entity) || this.status != EventStatus.PROGRESSING || this.colony.getState() != ColonyState.ACTIVE) {
            return;
        }
        this.archers.remove(entity);
        this.boss.remove(entity);
        this.normal.remove(entity);
        this.respawns.add(new Tuple<EntityType, BlockPos>(entity.m_6095_(), entity.m_20183_()));
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        if (entity instanceof AbstractEntityMinecoloniesRaider) {
            this.colony.getRaiderManager().onRaiderDeath((AbstractEntityMinecoloniesRaider)entity);
        }
    }

    protected void spawnHorde(BlockPos spawnPos, IColony colony, int id, int numberOfBosses, int numberOfArchers, int numberOfRaiders) {
        RaiderMobUtils.spawn(this.getNormalRaiderType(), numberOfRaiders, spawnPos, colony.getWorld(), colony, id);
        RaiderMobUtils.spawn(this.getBossRaiderType(), numberOfBosses, spawnPos, colony.getWorld(), colony, id);
        RaiderMobUtils.spawn(this.getArcherRaiderType(), numberOfArchers, spawnPos, colony.getWorld(), colony, id);
    }

    private void prepareEvent() {
        if (--this.campFireTime <= 0) {
            this.status = EventStatus.PROGRESSING;
        }
    }

    private void spawnCampFires(BlockPos pos) {
        int fireCount = Math.max(1, this.horde.hordeSize / 5);
        block0: for (int i = 0; i < fireCount; ++i) {
            for (int tries = 0; tries < 3; ++tries) {
                BlockPos spawn = BlockPosUtil.getRandomPosition(this.colony.getWorld(), pos, BlockPos.f_121853_, 3, 7, true);
                if (spawn == BlockPos.f_121853_) continue;
                this.colony.getWorld().m_46597_(spawn, Blocks.f_50683_.m_49966_());
                this.campFires.add(spawn);
                continue block0;
            }
        }
    }

    @Override
    public void onFinish() {
        this.colony.getRaiderManager().onRaidEventFinished(this);
        for (Entity entity : this.getEntities()) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        for (BlockPos pos : this.campFires) {
            this.colony.getWorld().m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        this.raidBar.m_8321_(false);
        this.raidBar.m_7706_();
    }

    @Override
    public void onNightFall() {
        --this.daysToGo;
        if (this.daysToGo < 0) {
            this.status = EventStatus.DONE;
        }
    }

    public void setHorde(Horde horde) {
        this.horde = horde;
    }

    public BlockPos getRandomCampfire() {
        if (this.campFires.isEmpty()) {
            return null;
        }
        return this.campFires.get(this.colony.getWorld().f_46441_.m_188503_(this.campFires.size()));
    }

    @Override
    public void onStart() {
        BlockPos spawnPos;
        if (this.spawnPathResult != null && this.spawnPathResult.isDone()) {
            Path path = this.spawnPathResult.getPath();
            if (path != null && path.m_77403_()) {
                this.spawnPoint = path.m_77395_().m_77288_();
            }
            this.wayPoints = ShipBasedRaiderUtils.createWaypoints(this.colony.getWorld(), path, 20);
        }
        if ((spawnPos = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, MAX_SPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10)) == null) {
            this.status = EventStatus.CANCELED;
            return;
        }
        this.status = EventStatus.PREPARING;
        this.spawnCampFires(spawnPos);
        double dist = this.colony.getCenter().m_123331_((Vec3i)spawnPos);
        this.campFireTime = dist < (double)(MIN_CENTER_DISTANCE * MIN_CENTER_DISTANCE) ? 6 : 3;
        this.spawnHorde(spawnPos, this.colony, this.id, this.horde.numberOfBosses, this.horde.numberOfArchers, this.horde.numberOfRaiders);
        this.updateRaidBar();
        MessageUtils.format("event.minecolonies.raidmessage" + this.horde.getMessageID(), BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText(), this.colony.getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
        Log.getLogger().debug("Raiders coming from: " + this.spawnPoint.m_123344_() + " towards colony: " + this.colony.getName());
        PlayAudioMessage audio = new PlayAudioMessage(this.horde.initialSize <= 5 ? RaidSounds.WARNING_EARLY : RaidSounds.WARNING, SoundSource.HOSTILE);
        PlayAudioMessage.sendToAll(this.getColony(), false, false, audio);
    }

    public IColony getColony() {
        return this.colony;
    }

    protected void updateRaidBar() {
        Component directionName = BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText();
        this.raidBar.m_6456_((Component)this.getDisplayName().m_130946_(" - ").m_7220_(directionName));
        for (Player player : this.colony.getPackageManager().getCloseSubscribers()) {
            this.raidBar.m_6543_((ServerPlayer)player);
        }
        this.raidBar.m_8321_(true);
    }

    protected abstract MutableComponent getDisplayName();

    @Override
    public void onUpdate() {
        BlockPos spawnPos;
        if (this.status == EventStatus.PREPARING) {
            this.prepareEvent();
        }
        this.updateRaidBar();
        this.colony.getRaiderManager().setNightsSinceLastRaid(0);
        if (this.horde.hordeSize <= 0) {
            this.status = EventStatus.DONE;
            return;
        }
        if (!this.respawns.isEmpty()) {
            for (Tuple<EntityType<?>, BlockPos> entry : this.respawns) {
                BlockPos spawnPos2 = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(entry.getB(), this.colony, MAX_RESPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10);
                if (spawnPos2 == null) continue;
                RaiderMobUtils.spawn(entry.getA(), 1, spawnPos2, this.colony.getWorld(), this.colony, this.id);
            }
            this.respawns.clear();
            return;
        }
        if (this.boss.size() + this.archers.size() + this.normal.size() < this.horde.numberOfBosses + this.horde.numberOfRaiders + this.horde.numberOfArchers && (spawnPos = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, MAX_RESPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10)) != null) {
            this.spawnHorde(spawnPos, this.colony, this.id, this.horde.numberOfBosses - this.boss.size(), this.horde.numberOfArchers - this.archers.size(), this.horde.numberOfRaiders - this.normal.size());
        }
        if ((double)(this.horde.numberOfBosses + this.horde.numberOfRaiders + this.horde.numberOfArchers) < Math.floor((double)this.horde.initialSize * 0.1)) {
            this.announceWin();
            this.status = EventStatus.DONE;
        }
        for (Entity entity : this.getEntities()) {
            if (!entity.m_6084_() || !WorldUtil.isEntityBlockLoaded((LevelAccessor)this.colony.getWorld(), entity.m_20183_())) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                this.respawns.add(new Tuple<EntityType, BlockPos>(entity.m_6095_(), entity.m_20183_()));
                continue;
            }
            if (!this.colony.getRaiderManager().areSpiesEnabled() && (long)(this.horde.numberOfBosses + this.horde.numberOfRaiders + this.horde.numberOfArchers) >= Math.round((double)this.horde.initialSize * 0.15)) continue;
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 550));
        }
    }

    private void announceWin() {
        MessageUtils.format("com.minecolonies.coremod.raid.end." + this.getEventTypeID().m_135815_() + ColonyConstants.rand.nextInt(3), BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText()).sendTo(this.colony, true).forManagers();
    }

    protected void sendHordeMessage() {
        int total = 0;
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            if (!(event instanceof HordeRaidEvent)) continue;
            total += ((HordeRaidEvent)event).horde.hordeSize;
        }
        this.raidBar.m_142711_((float)this.horde.hordeSize / (float)this.horde.initialSize);
        if (total == 0) {
            this.announceWin();
        } else if (total > 0 && total <= 5) {
            MessageUtils.format("com.minecolonies.coremod.barbarians.left", total).sendTo(this.colony).forManagers();
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("mc_event_id", this.id);
        BlockPosUtil.write(compound, "spawnPos", this.spawnPoint);
        ListTag campFiresNBT = new ListTag();
        for (BlockPos pos : this.campFires) {
            campFiresNBT.add((Object)BlockPosUtil.write(new CompoundTag(), "pos", pos));
        }
        compound.m_128365_("campfirelist", (Tag)campFiresNBT);
        compound.m_128405_("eventStatus", this.status.ordinal());
        compound.m_128405_("pirateDaysLeft", this.daysToGo);
        this.horde.writeToNbt(compound);
        BlockPosUtil.writePosListToNBT(compound, "waypoints", this.wayPoints);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.id = compound.m_128451_("mc_event_id");
        this.setHorde(Horde.loadFromNbt(compound));
        this.spawnPoint = BlockPosUtil.read(compound, "spawnPos");
        for (Tag posCompound : compound.m_128437_("campfirelist", 10)) {
            this.campFires.add(BlockPosUtil.read((CompoundTag)posCompound, "pos"));
        }
        this.status = EventStatus.values()[compound.m_128451_("eventStatus")];
        this.daysToGo = compound.m_128451_("pirateDaysLeft");
        this.wayPoints = BlockPosUtil.readPosListFromNBT(compound, "waypoints");
    }

    @Override
    public void setCampFireTime(int time) {
        this.campFireTime = time;
    }

    @Override
    public void addSpawner(BlockPos pos) {
    }

    @Override
    public List<BlockPos> getWayPoints() {
        return this.wayPoints;
    }

    public void setSpawnPath(PathResult result) {
        this.spawnPathResult = result;
    }
}

