/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules.settings;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.placement.StructureIterators;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuilderModeSetting
extends StringSetting {
    public static final String NEEDS_RESEARCH_REASON = "com.minecolonies.coremod.settings.reason.needsresearch";
    public static final String BUILDER_MODES_RESEARCH = "com.minecolonies.research.technology.buildermodes.name";

    public BuilderModeSetting() {
        super(StructureIterators.getKeySet().stream().sorted(String::compareToIgnoreCase).toList(), 0);
        this.set((String)Structurize.getConfig().getServer().iteratorType.get());
    }

    public BuilderModeSetting(List<String> value, int curr) {
        super(StructureIterators.getKeySet().stream().sorted(String::compareToIgnoreCase).toList(), 0);
        this.set(value.get(curr));
    }

    @NotNull
    public static String getActualValue(@NotNull IBuilding building) {
        return building.getSettingValueOrDefault(BuildingBuilder.BUILDING_MODE, (String)Structurize.getConfig().getServer().iteratorType.get());
    }

    @Override
    protected Component getDisplayText() {
        return Component.m_237115_((String)("com.ldtteam.structurize.iterators." + this.getSettings().get(this.getCurrentIndex())));
    }

    @Override
    public Component getToolTipText() {
        return Component.m_237115_((String)("com.ldtteam.structurize.iterators." + this.getSettings().get(this.getCurrentIndex()) + ".tooltip"));
    }

    @Override
    public boolean isActive(ISettingsModule module) {
        return module.getBuilding().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BUILDER_MODE) > 0.0;
    }

    @Override
    public boolean isActive(ISettingsModuleView module) {
        return module.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BUILDER_MODE) > 0.0;
    }

    @Override
    @Nullable
    public Component getInactiveReason() {
        return Component.m_237110_((String)NEEDS_RESEARCH_REASON, (Object[])new Object[]{Component.m_237115_((String)BUILDER_MODES_RESEARCH)});
    }
}

