/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAltersRequiredItems;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.MinimumStack;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class RestaurantMenuModule
extends AbstractBuildingModule
implements IPersistentModule,
ITickingModule,
IAltersRequiredItems {
    public static final int STOCK_PER_LEVEL = 5;
    private static final String TAG_MENU = "menu";
    protected final Set<ItemStorage> menu = new HashSet<ItemStorage>();
    private final boolean canCook;
    private final Function<IBuilding, Integer> expectedStock;

    public Set<ItemStorage> getMenu() {
        return this.menu;
    }

    public RestaurantMenuModule(boolean canCook, Function<IBuilding, Integer> expectedStock) {
        this.canCook = canCook;
        this.expectedStock = expectedStock;
    }

    public void addMenuItem(ItemStack itemStack) {
        if (!FoodUtils.EDIBLE.test(itemStack)) {
            Log.getLogger().warn("Tried to add nonedible food stack: " + String.valueOf(itemStack));
            return;
        }
        if (this.menu.size() >= this.building.getBuildingLevel() * 5) {
            return;
        }
        this.menu.add(new ItemStorage(itemStack));
        this.markDirty();
    }

    public void removeMenuItem(ItemStack itemStack) {
        this.menu.remove(new ItemStorage(itemStack));
        Collection list = this.building.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(Stack.class), new ArrayList());
        IToken<?> token = this.getMatchingRequest(itemStack, list);
        if (token != null) {
            this.building.getColony().getRequestManager().updateRequestState(token, RequestState.CANCELLED);
        }
        this.markDirty();
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), this.building.getPosition())) {
            Collection list = this.building.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(MinimumStack.class), new ArrayList());
            for (ItemStorage menuItem : this.menu) {
                IRecipeStorage iRecipeStorage;
                ItemStack originalStack = menuItem.getItemStack().m_41777_();
                if (originalStack.m_41619_()) continue;
                ItemStack requestStack = originalStack;
                ItemStack rawStack = ItemStack.f_41583_;
                if (this.canCook && (iRecipeStorage = MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getFirstSmeltingRecipeByResult(menuItem)) instanceof RecipeStorage) {
                    RecipeStorage recipeStorage = (RecipeStorage)iRecipeStorage;
                    rawStack = recipeStorage.getInput().get(0).getItemStack().m_41777_();
                }
                int target = originalStack.m_41741_() * this.getExpectedStock();
                int count = InventoryUtils.hasBuildingEnoughElseCount(this.building, new ItemStorage(originalStack, true), target);
                int rawCount = rawStack.m_41619_() ? 0 : InventoryUtils.hasBuildingEnoughElseCount(this.building, new ItemStorage(rawStack, true), target);
                int delta = target - count - rawCount;
                if (MathUtils.RANDOM.nextBoolean() && !rawStack.m_41619_()) {
                    requestStack = rawStack.m_41777_();
                }
                IToken<?> request = this.getMatchingRequest(requestStack, list);
                if (delta > (this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MIN_ORDER) > 0.0 ? target / 4 : 0)) {
                    if (request != null) continue;
                    int qty = Math.min(64, Math.min(requestStack.m_41741_(), delta));
                    MinimumStack stack = new MinimumStack(requestStack, false, true, ItemStackUtils.EMPTY, qty, 1);
                    stack.setCanBeResolvedByBuilding(false);
                    this.building.createRequest(stack, true);
                    continue;
                }
                if (request == null || delta > 0) continue;
                this.building.getColony().getRequestManager().updateRequestState(request, RequestState.CANCELLED);
            }
        }
    }

    private IToken<?> getMatchingRequest(ItemStack stack, Collection<IToken<?>> list) {
        for (IToken<?> token : list) {
            IRequest<?> iRequest = this.building.getColony().getRequestManager().getRequestForToken(token);
            if (iRequest == null || !(iRequest.getRequest() instanceof Stack) || !ItemStackUtils.compareItemStacksIgnoreStackSize(((Stack)iRequest.getRequest()).getStack(), stack).booleanValue()) continue;
            return token;
        }
        return null;
    }

    public int getExpectedStock() {
        return this.expectedStock.apply(this.building);
    }

    @Override
    public void alterItemsToBeKept(TriConsumer<Predicate<ItemStack>, Integer, Boolean> consumer) {
        for (ItemStorage menuItem : this.menu) {
            IRecipeStorage iRecipeStorage;
            consumer.accept(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, menuItem.getItemStack(), false, true), (Object)(menuItem.getItemStack().m_41741_() * this.getExpectedStock()), (Object)false);
            if (!this.canCook || !((iRecipeStorage = MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getFirstSmeltingRecipeByResult(menuItem)) instanceof RecipeStorage)) continue;
            RecipeStorage recipeStorage = (RecipeStorage)iRecipeStorage;
            ItemStack smeltStack = recipeStorage.getInput().get(0).getItemStack();
            consumer.accept(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, smeltStack, false, true), (Object)(smeltStack.m_41741_() * this.getExpectedStock()), (Object)false);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.menu.clear();
        ListTag minimumStockTagList = compound.m_128437_(TAG_MENU, 10);
        for (int i = 0; i < minimumStockTagList.size(); ++i) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)minimumStockTagList.m_128728_(i));
            if (!FoodUtils.EDIBLE.test(itemStack)) continue;
            this.menu.add(new ItemStorage(itemStack));
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        @NotNull ListTag minimumStockTagList = new ListTag();
        for (ItemStorage menuItem : this.menu) {
            minimumStockTagList.add((Object)menuItem.getItemStack().m_41739_(new CompoundTag()));
        }
        compound.m_128365_(TAG_MENU, (Tag)minimumStockTagList);
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.menu.size());
        for (ItemStorage menuItem : this.menu) {
            buf.m_130055_(menuItem.getItemStack());
        }
    }
}

