/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.minecolonies.api.colony.IAnimalData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IManagedAnimal;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.animal.Animal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalData
implements IAnimalData {
    private final int id;
    private UUID uuid;
    private final IColony colony;
    @Nullable
    private IBuilding homeBuilding;
    private float combatCooldown = 0.0f;
    private float maxHealth = 0.0f;
    private boolean isDirty = false;
    private BlockPos lastPosition = new BlockPos(0, 0, 0);
    @NotNull
    private WeakReference<IManagedAnimal<? extends Animal>> entity = new WeakReference<Object>(null);

    public AnimalData(int id, IColony colony) {
        this.id = id;
        this.colony = colony;
    }

    @Override
    public void update(int tickRate) {
        if (!this.getManagedAnimal().isPresent() || !this.getManagedAnimal().get().getEntity().m_6084_()) {
            return;
        }
    }

    @Override
    public void initEntityValues() {
        if (!this.getManagedAnimal().isPresent()) {
            Log.getLogger().warn("Missing entity upon adding data to that entity!" + String.valueOf(this), (Throwable)new Exception());
            return;
        }
        IManagedAnimal<? extends Animal> animal = this.getManagedAnimal().get();
        this.setLastPosition(animal.getEntity().m_20183_());
    }

    public static IAnimalData loadAnimalFromNBT(IColony colony, CompoundTag nbt) {
        AnimalData data = new AnimalData(nbt.m_128451_("id"), colony);
        data.deserializeNBT((Tag)nbt);
        return data;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("id", this.getId());
        BlockPosUtil.write(compoundNBT, "pos", this.getManagedAnimal().isPresent() ? this.getManagedAnimal().get().getEntity().m_20183_() : this.lastPosition);
        BlockPosUtil.write(compoundNBT, "animalhome", this.homeBuilding != null ? this.homeBuilding.getID() : BlockPos.f_121853_);
        compoundNBT.m_128350_("maxhealth", this.maxHealth);
        compoundNBT.m_128350_("combatcooldown", this.getCombatCooldown());
        compoundNBT.m_128362_("uuid", this.uuid != null ? this.uuid : UUID.randomUUID());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbtTagCompound) {
        BlockPos homePos;
        this.lastPosition = BlockPosUtil.read(nbtTagCompound, "pos");
        BlockPos blockPos = homePos = nbtTagCompound.m_128441_("animalhome") ? BlockPosUtil.read(nbtTagCompound, "animalhome") : BlockPos.f_121853_;
        if (!homePos.equals((Object)BlockPos.f_121853_)) {
            this.homeBuilding = this.colony.getBuildingManager().getBuilding(homePos);
        }
        this.maxHealth = nbtTagCompound.m_128441_("maxhealth") ? nbtTagCompound.m_128457_("maxhealth") : 0.0f;
        this.setCombatCooldown(nbtTagCompound.m_128441_("combatcooldown") ? nbtTagCompound.m_128457_("combatcooldown") : 0.0f);
        this.uuid = nbtTagCompound.m_128441_("uuid") ? nbtTagCompound.m_128342_("uuid") : UUID.randomUUID();
    }

    @Override
    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.homeBuilding != null);
        if (this.homeBuilding != null) {
            buf.m_130064_(this.homeBuilding.getID());
        }
        buf.writeFloat(this.combatCooldown);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    @NotNull
    public Optional<IManagedAnimal<? extends Animal>> getManagedAnimal() {
        IManagedAnimal animal = (IManagedAnimal)this.entity.get();
        if (animal != null && animal.getEntity().m_213877_()) {
            this.entity.clear();
            return Optional.empty();
        }
        return Optional.ofNullable(animal);
    }

    @Override
    public void setManagedAnimal(@Nullable IManagedAnimal<? extends Animal> animal) {
        if (this.entity.get() != null) {
            this.entity.clear();
        }
        if (animal != null) {
            this.entity = new WeakReference<IManagedAnimal<? extends Animal>>(animal);
            this.uuid = animal.getEntity().m_20148_();
            this.maxHealth = animal.getEntity().m_21233_();
        }
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    @Nullable
    public IBuilding getHomeBuilding() {
        return this.homeBuilding;
    }

    @Override
    public void setHomeBuilding(@Nullable IBuilding building) {
        this.homeBuilding = building;
        this.markDirty();
    }

    @Override
    public void onRemoveBuilding(IBuilding building) {
        if (this.homeBuilding != null && this.homeBuilding.getID().equals((Object)building.getID())) {
            this.setHomeBuilding(null);
        }
    }

    @Override
    public void setLastPosition(BlockPos lastPosition) {
        this.lastPosition = lastPosition;
    }

    @Override
    public BlockPos getLastPosition() {
        return this.lastPosition;
    }

    @Override
    public float getCombatCooldown() {
        return this.combatCooldown;
    }

    @Override
    public void setCombatCooldown(float newCooldown) {
        newCooldown = Math.min(newCooldown, this.maxHealth);
        this.combatCooldown = Math.max(0.0f, newCooldown);
    }
}

