/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.RestaurantMenuModuleView;
import com.minecolonies.core.network.messages.server.colony.building.AlterRestaurantMenuItemMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RestaurantMenuModuleWindow
extends AbstractModuleWindow<RestaurantMenuModuleView> {
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private final ScrollingList menuList;
    protected final ScrollingList resourceList;
    private String filter = "";
    protected List<ItemStorage> groupedItemList;
    protected final List<ItemStorage> currentDisplayedList = new ArrayList<ItemStorage>();
    private int tick;
    private List<ItemStorage> menu;

    public RestaurantMenuModuleWindow(RestaurantMenuModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutfoodstock.xml"));
        this.menuList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.registerButton("switch", this::switchClicked);
        this.registerButton("removeStock", this::removeStock);
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        this.groupedItemList = new ArrayList<ItemStorage>(IColonyManager.getInstance().getCompatibilityManager().getEdibles(moduleView.getBuildingView().getBuildingLevel() - 1));
        ((TextField)this.window.findPaneOfTypeByID("input", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    private void removeStock(Button button) {
        int row = this.menuList.getListElementIndexByPane((Pane)button);
        ItemStorage storage = this.menu.get(row);
        ((RestaurantMenuModuleView)this.moduleView).getMenu().remove(storage);
        Network.getNetwork().sendToServer(AlterRestaurantMenuItemMessage.removeMenuItem(this.buildingView, storage.getItemStack(), ((RestaurantMenuModuleView)this.moduleView).getProducer().getRuntimeID()));
        this.updateStockList();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateStockList();
        this.updateResources();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private void switchClicked(@NotNull Button button) {
        if (!((RestaurantMenuModuleView)this.moduleView).hasReachedLimit()) {
            int row = this.resourceList.getListElementIndexByPane((Pane)button);
            ItemStorage storage = this.currentDisplayedList.get(row);
            Network.getNetwork().sendToServer(AlterRestaurantMenuItemMessage.addMenuItem(this.buildingView, storage.getItemStack(), ((RestaurantMenuModuleView)this.moduleView).getProducer().getRuntimeID()));
            ((RestaurantMenuModuleView)this.moduleView).getMenu().add(storage);
            this.updateStockList();
            this.resourceList.refreshElementPanes();
        }
    }

    private void updateStockList() {
        this.menu = new ArrayList<ItemStorage>(((RestaurantMenuModuleView)this.moduleView).getMenu());
        this.applySorting(this.menu);
        if (this.menu.isEmpty()) {
            this.findPaneByID("warning").show();
        } else {
            this.findPaneByID("warning").hide();
            boolean hasGoodMinecoloniesFood = false;
            for (ItemStorage menuItem : this.menu) {
                IMinecoloniesFoodItem minecoloniesFoodItem;
                Item item = menuItem.getItem();
                if (!(item instanceof IMinecoloniesFoodItem) || (minecoloniesFoodItem = (IMinecoloniesFoodItem)item).getTier() < 2) continue;
                hasGoodMinecoloniesFood = true;
                break;
            }
            if (hasGoodMinecoloniesFood) {
                this.findPaneByID("poorwarning").hide();
            } else {
                this.findPaneByID("poorwarning").show();
            }
        }
        this.menuList.enable();
        this.menuList.show();
        this.menuList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return RestaurantMenuModuleWindow.this.menu.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = RestaurantMenuModuleWindow.this.menu.get(index).getItemStack().m_41777_();
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.m_41786_());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
                Gradient gradient = (Gradient)rowPane.findPaneOfTypeByID("gradient", Gradient.class);
                Item item = resource.m_41720_();
                if (item instanceof IMinecoloniesFoodItem) {
                    IMinecoloniesFoodItem foodItem = (IMinecoloniesFoodItem)item;
                    if (foodItem.getTier() == 3) {
                        gradient.setGradientStart(255, 215, 0, 255);
                        gradient.setGradientEnd(255, 215, 0, 255);
                    } else if (foodItem.getTier() == 2) {
                        gradient.setGradientStart(211, 211, 211, 255);
                        gradient.setGradientEnd(211, 211, 211, 255);
                    } else if (foodItem.getTier() == 1) {
                        gradient.setGradientStart(205, 127, 50, 255);
                        gradient.setGradientEnd(205, 127, 50, 255);
                    }
                    ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.core.gui.restaurant.foodquality", (Object[])new Object[]{FoodUtils.getBuildingLevelForFood(resource)}))).hoverPane((Pane)gradient).build();
                } else {
                    gradient.setGradientStart(0, 0, 0, 0);
                    gradient.setGradientEnd(0, 0, 0, 0);
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.core.gui.restaurant.foodquality", (Object[])new Object[]{FoodUtils.getBuildingLevelForFood(resource)}))).appendNL(Component.m_237115_((String)"com.minecolonies.core.gui.restaurant.vanillafoodquality"))).hoverPane((Pane)gradient).build();
                }
            }
        });
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.m_41778_().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.m_41786_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.currentDisplayedList.clear();
        for (ItemStorage storage : this.groupedItemList) {
            if (!filterPredicate.test(storage.getItemStack())) continue;
            this.currentDisplayedList.add(storage);
        }
        this.applySorting(this.currentDisplayedList);
        this.updateResourceList();
    }

    protected void applySorting(List<ItemStorage> displayedList) {
        displayedList.sort((o1, o2) -> {
            int n;
            int n2;
            Item patt9847$temp = o1.getItem();
            if (patt9847$temp instanceof IMinecoloniesFoodItem) {
                IMinecoloniesFoodItem foodItem = (IMinecoloniesFoodItem)patt9847$temp;
                n2 = foodItem.getTier() * -100;
            } else {
                n2 = -o1.getItemStack().getFoodProperties(null).m_38744_();
            }
            int score = n2;
            Item patt10015$temp = o2.getItem();
            if (patt10015$temp instanceof IMinecoloniesFoodItem) {
                IMinecoloniesFoodItem foodItem2 = (IMinecoloniesFoodItem)patt10015$temp;
                n = foodItem2.getTier() * -100;
            } else {
                n = -o2.getItemStack().getFoodProperties(null).m_38744_();
            }
            int score2 = n;
            int scoreComparison = Integer.compare(score, score2);
            if (scoreComparison != 0) {
                return scoreComparison;
            }
            return o1.getItemStack().m_41611_().getString().toLowerCase(Locale.US).compareTo(o2.getItemStack().m_41611_().getString().toLowerCase(Locale.US));
        });
    }

    protected void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return RestaurantMenuModuleWindow.this.currentDisplayedList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = RestaurantMenuModuleWindow.this.currentDisplayedList.get(index).getItemStack();
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.m_41720_().m_7626_(resource).m_6879_());
                resourceLabel.setColors(7);
                ItemIcon itemIcon = (ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class);
                itemIcon.setItem(resource);
                boolean isInMenu = ((RestaurantMenuModuleView)RestaurantMenuModuleWindow.this.moduleView).getMenu().contains(new ItemStorage(resource));
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                Gradient gradient = (Gradient)rowPane.findPaneOfTypeByID("gradient", Gradient.class);
                Item item = resource.m_41720_();
                if (item instanceof IMinecoloniesFoodItem) {
                    IMinecoloniesFoodItem foodItem = (IMinecoloniesFoodItem)item;
                    if (foodItem.getTier() == 3) {
                        gradient.setGradientStart(255, 215, 0, 255);
                        gradient.setGradientEnd(255, 215, 0, 255);
                    } else if (foodItem.getTier() == 2) {
                        gradient.setGradientStart(211, 211, 211, 255);
                        gradient.setGradientEnd(211, 211, 211, 255);
                    } else if (foodItem.getTier() == 1) {
                        gradient.setGradientStart(205, 127, 50, 255);
                        gradient.setGradientEnd(205, 127, 50, 255);
                    }
                    ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.core.gui.restaurant.foodquality", (Object[])new Object[]{FoodUtils.getBuildingLevelForFood(resource)}))).hoverPane((Pane)gradient).build();
                } else {
                    gradient.setGradientStart(0, 0, 0, 0);
                    gradient.setGradientEnd(0, 0, 0, 0);
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.core.gui.restaurant.foodquality", (Object[])new Object[]{FoodUtils.getBuildingLevelForFood(resource)}))).appendNL(Component.m_237115_((String)"com.minecolonies.core.gui.restaurant.vanillafoodquality"))).hoverPane((Pane)gradient).build();
                }
                if (((RestaurantMenuModuleView)RestaurantMenuModuleWindow.this.moduleView).hasReachedLimit()) {
                    switchButton.disable();
                    ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237115_((String)RestaurantMenuModuleWindow.LABEL_LIMIT_REACHED))).hoverPane((Pane)switchButton).build();
                }
                if (isInMenu) {
                    switchButton.disable();
                } else {
                    switchButton.enable();
                }
            }
        });
    }
}

