/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildingextensions.PlantationField;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingPlantation;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PlantationFieldsModuleWindow
extends AbstractModuleWindow<BuildingPlantation.PlantationFieldsModuleView> {
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_BUTTON_ASSIGN = "assign";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String TAG_FIELD_COUNT = "fieldCount";
    private static final String TAG_PLANT_COUNT = "plantCount";
    private static final String TAG_ICON = "icon";
    private static final String TEXTURE_ASSIGN_ON_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini_check.png";
    private static final String TEXTURE_ASSIGN_ON_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled_check.png";
    private static final String TEXTURE_ASSIGN_OFF_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini.png";
    private static final String TEXTURE_ASSIGN_OFF_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled.png";
    private ScrollingList fieldList;

    public PlantationFieldsModuleWindow(BuildingPlantation.PlantationFieldsModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutplantationfields.xml"));
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
    }

    private void assignmentModeClicked(@NotNull Button button) {
        ((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).setAssignFieldManually(!((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).assignFieldManually());
        this.updateUI();
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane((Pane)button);
        IBuildingExtension field = ((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).getFields().get(row);
        if (field.isTaken()) {
            ((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).freeField(field);
        } else {
            ((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).assignField(field);
        }
        this.updateUI();
    }

    private void updateUI() {
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText(Component.m_237115_((String)(((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).assignFieldManually() ? "com.minecolonies.coremod.gui.hiring.on" : "com.minecolonies.coremod.gui.hiring.off")));
        ((Text)this.findPaneOfTypeByID(TAG_FIELD_COUNT, Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.workerhuts.fields.fieldcount", (Object[])new Object[]{((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).getOwnedFields().size(), ((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).getMaxFieldCount()}));
        ((Text)this.findPaneOfTypeByID(TAG_PLANT_COUNT, Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.workerhuts.fields.plantcount", (Object[])new Object[]{((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).getCurrentPlants(), ((BuildingPlantation.PlantationFieldsModuleView)this.moduleView).getMaxConcurrentPlants()}));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((BuildingPlantation.PlantationFieldsModuleView)PlantationFieldsModuleWindow.this.moduleView).getFields().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                PlantationField field = (PlantationField)((BuildingPlantation.PlantationFieldsModuleView)PlantationFieldsModuleWindow.this.moduleView).getFields().get(index);
                Item item = field.getModule().getItem();
                ((ItemIcon)rowPane.findPaneOfTypeByID(PlantationFieldsModuleWindow.TAG_ICON, ItemIcon.class)).setItem(new ItemStack((ItemLike)item));
                String distance = Integer.toString(field.getSqDistance(PlantationFieldsModuleWindow.this.buildingView));
                BlockPosUtil.DirectionResult direction = BlockPosUtil.calcDirection(PlantationFieldsModuleWindow.this.buildingView.getPosition(), field.getPosition());
                MutableComponent directionText = switch (direction) {
                    case BlockPosUtil.DirectionResult.SAME -> Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.fields.plantation.direction.exact");
                    case BlockPosUtil.DirectionResult.UP, BlockPosUtil.DirectionResult.DOWN -> direction.getLongText();
                    default -> Component.m_237110_((String)"com.minecolonies.coremod.gui.workerhuts.fields.distance", (Object[])new Object[]{Component.m_237113_((String)(distance + "m")), direction.getShortText()});
                };
                ((Text)rowPane.findPaneOfTypeByID(PlantationFieldsModuleWindow.TAG_DISTANCE, Text.class)).setText((Component)directionText);
                ButtonImage assignButton = (ButtonImage)rowPane.findPaneOfTypeByID(PlantationFieldsModuleWindow.TAG_BUTTON_ASSIGN, ButtonImage.class);
                assignButton.setEnabled(((BuildingPlantation.PlantationFieldsModuleView)PlantationFieldsModuleWindow.this.moduleView).assignFieldManually());
                assignButton.show();
                assignButton.setHoverPane(null);
                if (field.isTaken()) {
                    PlantationFieldsModuleWindow.this.setAssignButtonTexture(assignButton, true);
                } else {
                    PlantationFieldsModuleWindow.this.setAssignButtonTexture(assignButton, false);
                    if (!((BuildingPlantation.PlantationFieldsModuleView)PlantationFieldsModuleWindow.this.moduleView).canAssignField(field)) {
                        assignButton.disable();
                        MutableComponent warningTooltip = ((BuildingPlantation.PlantationFieldsModuleView)PlantationFieldsModuleWindow.this.moduleView).getFieldWarningTooltip(field);
                        if (warningTooltip != null && ((BuildingPlantation.PlantationFieldsModuleView)PlantationFieldsModuleWindow.this.moduleView).assignFieldManually()) {
                            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(warningTooltip.m_130940_(ChatFormatting.RED))).hoverPane((Pane)assignButton).build();
                        }
                    }
                }
            }
        });
        this.updateUI();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateUI();
    }

    private void setAssignButtonTexture(ButtonImage button, boolean isOn) {
        if (isOn) {
            button.setImage(new ResourceLocation(TEXTURE_ASSIGN_ON_NORMAL), true);
            button.setImageDisabled(new ResourceLocation(TEXTURE_ASSIGN_ON_DISABLED), true);
        } else {
            button.setImage(new ResourceLocation(TEXTURE_ASSIGN_OFF_NORMAL), true);
            button.setImageDisabled(new ResourceLocation(TEXTURE_ASSIGN_OFF_DISABLED), true);
        }
    }
}

